/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.function.Predicates;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnId;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.relational.mapping.MaskStrings;
import io.debezium.relational.mapping.PropagateSourceMetadataToSchemaParameter;
import io.debezium.relational.mapping.TruncateColumn;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.errors.ConnectException;

@Immutable
public class ColumnMappers {
    private final List<MapperRule> rules;

    public static Builder build() {
        return new Builder(null);
    }

    public static ColumnMappers create(RelationalDatabaseConnectorConfig connectorConfig) {
        Builder builder = new Builder(connectorConfig.getTableIdMapper());
        Configuration config = connectorConfig.getConfig();
        config.forEachMatchingFieldNameWithInteger("column\\.truncate\\.to\\.(\\d+)\\.chars", builder::truncateStrings);
        config.forEachMatchingFieldNameWithInteger("column\\.mask\\.with\\.(\\d+)\\.chars", builder::maskStrings);
        config.forEachMatchingFieldName("column\\.propagate\\.source\\.type", builder::propagateSourceTypeToSchemaParameter);
        config.forEachMatchingFieldName("datatype\\.propagate\\.source\\.type", builder::propagateSourceTypeToSchemaParameterByDatatype);
        Pattern hashAlgorithmAndSaltExtractPattern = Pattern.compile("((?<hashAlgorithm>[^.]+)\\.with\\.salt\\.(?<salt>.+))");
        config.forEachMatchingFieldNameWithString("column\\.mask\\.hash\\." + hashAlgorithmAndSaltExtractPattern.pattern(), (fullyQualifiedColumnNames, hashAlgorithmAndSalt) -> {
            Matcher matcher = hashAlgorithmAndSaltExtractPattern.matcher((CharSequence)hashAlgorithmAndSalt);
            if (matcher.matches()) {
                builder.maskStringsByHashing((String)fullyQualifiedColumnNames, matcher.group("hashAlgorithm"), matcher.group("salt"));
            }
        });
        config.forEachMatchingFieldNameWithString("column\\.mask\\.hash\\.v2\\." + hashAlgorithmAndSaltExtractPattern.pattern(), (fullyQualifiedColumnNames, hashAlgorithmAndSalt) -> {
            Matcher matcher = hashAlgorithmAndSaltExtractPattern.matcher((CharSequence)hashAlgorithmAndSalt);
            if (matcher.matches()) {
                builder.maskStringsByHashingV2((String)fullyQualifiedColumnNames, matcher.group("hashAlgorithm"), matcher.group("salt"));
            }
        });
        return builder.build();
    }

    private ColumnMappers(List<MapperRule> rules) {
        assert (rules != null);
        this.rules = new ArrayList<MapperRule>(rules);
    }

    public ValueConverter mappingConverterFor(Table table, Column column) {
        return this.mappingConverterFor(table.id(), column);
    }

    public ValueConverter mappingConverterFor(TableId tableId, Column column) {
        ColumnMapper mapper = this.mapperFor(tableId, column);
        return mapper != null ? mapper.create(column) : null;
    }

    public ColumnMapper mapperFor(TableId tableId, Column column) {
        Optional<MapperRule> matchingRule = this.rules.stream().filter(rule -> rule.matches(tableId, column)).findFirst();
        return matchingRule.map(mapperRule -> mapperRule.mapper).orElse(null);
    }

    protected static ColumnMapper instantiateMapper(Class<ColumnMapper> clazz, Configuration config) {
        try {
            ColumnMapper mapper = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (config != null) {
                mapper.initialize(config);
            }
            return mapper;
        }
        catch (InstantiationException e) {
            throw new ConnectException("Unable to instantiate column mapper class " + clazz.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectException("Unable to access column mapper class " + clazz.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new ConnectException("Unable to initialize the column mapper class " + clazz.getName() + ": " + e.getMessage(), e);
        }
    }

    public static class Builder {
        private final List<MapperRule> rules = new ArrayList<MapperRule>();
        private final Selectors.TableIdToStringMapper tableIdMapper;

        public Builder(Selectors.TableIdToStringMapper tableIdMapper) {
            this.tableIdMapper = tableIdMapper;
        }

        public Builder map(String fullyQualifiedColumnNames, ColumnMapper mapper) {
            BiPredicate<TableId, Column> columnMatcher = Predicates.includes(fullyQualifiedColumnNames, this::fullyQualifiedColumnName);
            this.rules.add(new MapperRule(columnMatcher, mapper));
            if (this.tableIdMapper != null) {
                columnMatcher = Predicates.includes(fullyQualifiedColumnNames, this::mappedTableColumnName);
                this.rules.add(new MapperRule(columnMatcher, mapper));
            }
            return this;
        }

        public String fullyQualifiedColumnName(TableId tableId, Column column) {
            ColumnId id = new ColumnId(tableId, column.name());
            return id.toString();
        }

        public String mappedTableColumnName(TableId tableId, Column column) {
            ColumnId id = new ColumnId(this.mappedTableId(tableId), column.name());
            return id.toString();
        }

        public Builder mapByDatatype(String columnDatatypes, ColumnMapper mapper) {
            BiPredicate<TableId, Column> columnMatcher = Predicates.includes(columnDatatypes, this::fullyQualifiedColumnDatatype);
            this.rules.add(new MapperRule(columnMatcher, mapper));
            if (this.tableIdMapper != null) {
                columnMatcher = Predicates.includes(columnDatatypes, this::mappedTableColumnDatatype);
                this.rules.add(new MapperRule(columnMatcher, mapper));
            }
            return this;
        }

        public String fullyQualifiedColumnDatatype(TableId tableId, Column column) {
            return tableId.toString() + "." + column.typeName();
        }

        public String mappedTableColumnDatatype(TableId tableId, Column column) {
            return this.mappedTableId(tableId).toString() + "." + column.typeName();
        }

        public Builder map(String fullyQualifiedColumnNames, Class<ColumnMapper> mapperClass) {
            return this.map(fullyQualifiedColumnNames, mapperClass, null);
        }

        public Builder map(String fullyQualifiedColumnNames, Class<ColumnMapper> mapperClass, Configuration config) {
            return this.map(fullyQualifiedColumnNames, ColumnMappers.instantiateMapper(mapperClass, config));
        }

        public Builder truncateStrings(String fullyQualifiedColumnNames, int maxLength) {
            return this.map(fullyQualifiedColumnNames, new TruncateColumn(maxLength));
        }

        public Builder maskStrings(String fullyQualifiedColumnNames, int numberOfChars) {
            return this.maskStrings(fullyQualifiedColumnNames, numberOfChars, '*');
        }

        public Builder maskStrings(String fullyQualifiedColumnNames, int numberOfChars, char maskChar) {
            return this.maskStrings(fullyQualifiedColumnNames, Strings.createString(maskChar, numberOfChars));
        }

        public Builder maskStrings(String fullyQualifiedColumnNames, String maskValue) {
            return this.map(fullyQualifiedColumnNames, new MaskStrings(maskValue));
        }

        public Builder maskStringsByHashing(String fullyQualifiedColumnNames, String hashAlgorithm, String salt) {
            return this.map(fullyQualifiedColumnNames, new MaskStrings(salt.getBytes(), hashAlgorithm, MaskStrings.HashingByteArrayStrategy.V1));
        }

        public Builder maskStringsByHashingV2(String fullyQualifiedColumnNames, String hashAlgorithm, String salt) {
            return this.map(fullyQualifiedColumnNames, new MaskStrings(salt.getBytes(), hashAlgorithm, MaskStrings.HashingByteArrayStrategy.V2));
        }

        public Builder propagateSourceTypeToSchemaParameter(String fullyQualifiedColumnNames, String value) {
            return this.map(value, new PropagateSourceMetadataToSchemaParameter());
        }

        public Builder propagateSourceTypeToSchemaParameterByDatatype(String columnDatatypes, String value) {
            return this.mapByDatatype(value, new PropagateSourceMetadataToSchemaParameter());
        }

        public Builder map(String fullyQualifiedColumnNames, String mapperClassName) {
            return this.map(fullyQualifiedColumnNames, mapperClassName, null);
        }

        public Builder map(String fullyQualifiedColumnNames, String mapperClassName, Configuration config) {
            Class<?> mapperClass = null;
            if (mapperClassName != null) {
                try {
                    mapperClass = this.getClass().getClassLoader().loadClass(mapperClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Unable to find column mapper class " + mapperClassName + ": " + e.getMessage(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new ConnectException("Column mapper class must implement " + ColumnMapper.class + " but does not: " + e.getMessage(), (Throwable)e);
                }
            }
            return this.map(fullyQualifiedColumnNames, mapperClass, config);
        }

        public ColumnMappers build() {
            return new ColumnMappers(this.rules);
        }

        private TableId mappedTableId(TableId tableId) {
            return new TableId(tableId.catalog(), tableId.schema(), tableId.table(), this.tableIdMapper);
        }
    }

    @Immutable
    protected static final class MapperRule {
        protected final BiPredicate<TableId, Column> predicate;
        protected final ColumnMapper mapper;

        protected MapperRule(BiPredicate<TableId, Column> predicate, ColumnMapper mapper) {
            this.predicate = predicate;
            this.mapper = mapper;
        }

        protected boolean matches(TableId tableId, Column column) {
            return this.predicate.test(tableId, column);
        }
    }
}

