/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.annotation.Immutable;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import java.nio.ByteBuffer;
import org.apache.kafka.connect.data.SchemaBuilder;

public class TruncateColumn
implements ColumnMapper {
    private final TruncatingValueConverter converter;

    public TruncateColumn(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Maximum length must be non-negative");
        }
        this.converter = new TruncatingValueConverter(maxLength);
    }

    @Override
    public ValueConverter create(Column column) {
        return this.isTruncationPossible(column) ? this.converter : ValueConverter.passthrough();
    }

    @Override
    public void alterFieldSchema(Column column, SchemaBuilder schemaBuilder) {
        if (this.isTruncationPossible(column)) {
            schemaBuilder.parameter("truncateLength", Integer.toString(this.converter.maxLength));
        }
    }

    protected boolean isTruncationPossible(Column column) {
        return column.length() < 0 || column.length() > this.converter.maxLength;
    }

    @Immutable
    protected static final class TruncatingValueConverter
    implements ValueConverter {
        protected final int maxLength;

        public TruncatingValueConverter(int maxLength) {
            this.maxLength = maxLength;
            assert (this.maxLength >= 0);
        }

        @Override
        public Object convert(Object value) {
            ByteBuffer buffer;
            if (value instanceof String) {
                String str = (String)value;
                if (str.length() > this.maxLength) {
                    return str.substring(0, this.maxLength);
                }
            } else if (value instanceof ByteBuffer && (buffer = (ByteBuffer)value).limit() > this.maxLength) {
                buffer.limit(this.maxLength);
                return buffer.slice();
            }
            return value;
        }
    }
}

