/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data.vector;

import io.debezium.data.vector.DoubleVector;
import io.debezium.data.vector.FloatVector;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class VectorDatatypeTest {
    @Test
    public void shouldParseDoubleVector() {
        List<Double> expectedVector = List.of(Double.valueOf(10.0), Double.valueOf(20.0), Double.valueOf(30.0));
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"[10,20,30]")).isEqualTo(expectedVector);
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"[ 10,20,30] ")).isEqualTo(expectedVector);
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)" [ 10,20,30 ]")).isEqualTo(expectedVector);
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"[10 ,20 ,30]")).isEqualTo(expectedVector);
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"[10.2 , 20, 30]")).isEqualTo(List.of(Double.valueOf(10.2), Double.valueOf(20.0), Double.valueOf(30.0)));
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"[10.2e-1 , 20, 30]")).isEqualTo(List.of(Double.valueOf(1.02), Double.valueOf(20.0), Double.valueOf(30.0)));
    }

    @Test
    public void shouldIgnoreErrorInDoubleVectorFormat() {
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"10,20,30]")).isNull();
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"[10,20,30")).isNull();
        Assertions.assertThat((List)DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"{10,20,30}")).isNull();
    }

    @Test(expected=NumberFormatException.class)
    public void shouldFailOnNumberInDoubleVectorFormat() {
        DoubleVector.fromLogical((Schema)DoubleVector.schema(), (String)"[a10,20,30]");
    }

    @Test
    public void shouldParseFloatVector() {
        List<Float> expectedVector = List.of(Float.valueOf(10.0f), Float.valueOf(20.0f), Float.valueOf(30.0f));
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"[10,20,30]")).isEqualTo(expectedVector);
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"[ 10,20,30] ")).isEqualTo(expectedVector);
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)" [ 10,20,30 ]")).isEqualTo(expectedVector);
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"[10 ,20 ,30]")).isEqualTo(expectedVector);
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"[10.2 , 20, 30]")).isEqualTo(List.of(Float.valueOf(10.2f), Float.valueOf(20.0f), Float.valueOf(30.0f)));
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"[10.2e-1 , 20, 30]")).isEqualTo(List.of(Float.valueOf(1.02f), Float.valueOf(20.0f), Float.valueOf(30.0f)));
    }

    @Test
    public void shouldIgnoreErrorInFloatVectorFormat() {
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"10,20,30]")).isNull();
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"[10,20,30")).isNull();
        Assertions.assertThat((List)FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"{10,20,30}")).isNull();
    }

    @Test(expected=NumberFormatException.class)
    public void shouldFailOnNumberInFloatVectorFormat() {
        FloatVector.fromLogical((Schema)FloatVector.schema(), (String)"[a10,20,30]");
    }
}

