/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.document.Array;
import io.debezium.document.ArrayReader;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentSerdes;
import io.debezium.util.Testing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DocumentSerdesTest
implements Testing {
    private static final DocumentSerdes SERDES = new DocumentSerdes();

    @Test
    public void shouldConvertFromBytesToDocument1() throws IOException {
        this.readAsStringAndBytes("json/sample1.json");
    }

    @Test
    public void shouldUseSerdeMethodToConvertFromBytesToDocument2() throws IOException {
        this.readAsStringAndBytes("json/sample2.json");
    }

    @Test
    public void shouldUseSerdeMethodToConvertFromBytesToDocument3() throws IOException {
        this.readAsStringAndBytes("json/sample3.json");
    }

    @Test
    public void shouldUseSerdeMethodToConvertFromBytesToDocumentForResponse1() throws IOException {
        this.readAsStringAndBytes("json/response1.json");
    }

    @Test
    public void shouldUseSerdeMethodToConvertFromBytesToDocumentForResponse2() throws IOException {
        this.readAsStringAndBytes("json/response2.json");
    }

    protected void readAsStringAndBytes(String resourceFile) throws IOException {
        String content = Testing.Files.readResourceAsString(resourceFile);
        Document doc = DocumentReader.defaultReader().read(content);
        this.roundTrip(doc, size -> Testing.print("message size " + size + " bytes: \n" + String.valueOf(doc)));
    }

    protected void roundTrip(Document doc, IntConsumer sizeAccumulator) {
        byte[] bytes = SERDES.serialize("topicA", doc);
        if (sizeAccumulator != null) {
            sizeAccumulator.accept(bytes.length);
        }
        Document reconstituted = SERDES.deserialize("topicA", bytes);
        Assertions.assertThat((Object)reconstituted).isEqualTo((Object)doc);
    }

    protected List<Document> readResources(String prefix, String ... resources) throws IOException {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (String resource : resources) {
            String content = Testing.Files.readResourceAsString(prefix + resource);
            Array array = null;
            try {
                Document doc = DocumentReader.defaultReader().read(content);
                array = doc.getArray((CharSequence)"entityChanges");
            }
            catch (IOException e) {
                array = ArrayReader.defaultReader().readArray(content);
            }
            array.forEach(entry -> documents.add(entry.getValue().asDocument()));
        }
        return documents;
    }
}

