/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics.activity;

import io.debezium.data.Envelope;
import io.debezium.metrics.activity.ActivityMonitoringMeter;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ActivityMonitoringMeterTest {
    ActivityMonitoringMeter activityMonitoringMeter;

    @Test
    public void whenNoEventIsReceivedAndNewCreatedMeterThenNoMetricsMustBeReturned() {
        this.activityMonitoringMeter = new ActivityMonitoringMeter();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfCreateEventsSeen()).isEmpty();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfUpdateEventsSeen()).isEmpty();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfDeleteEventsSeen()).isEmpty();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfTruncateEventsSeen()).isEmpty();
    }

    @Test
    public void whenInsertEventIsReceivedThenCorrectMetricsMustBeReturned() {
        this.activityMonitoringMeter = new ActivityMonitoringMeter();
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.CREATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.CREATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.UPDATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.DELETE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.anotherTable"), null, (Object)1L, null, Envelope.Operation.CREATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.anotherTable"), null, (Object)1L, null, Envelope.Operation.TRUNCATE);
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfCreateEventsSeen()).contains(new Map.Entry[]{Map.entry("db.schema.table", 2L), Map.entry("db.schema.anotherTable", 1L)});
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfUpdateEventsSeen()).contains(new Map.Entry[]{Map.entry("db.schema.table", 1L)});
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfDeleteEventsSeen()).contains(new Map.Entry[]{Map.entry("db.schema.table", 1L)});
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfTruncateEventsSeen()).contains(new Map.Entry[]{Map.entry("db.schema.anotherTable", 1L)});
    }

    @Test
    public void whenMeterIsResetThenNoMetricsMustBeReturned() {
        this.activityMonitoringMeter = new ActivityMonitoringMeter();
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.CREATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.CREATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.UPDATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.table"), null, (Object)1L, null, Envelope.Operation.DELETE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.anotherTable"), null, (Object)1L, null, Envelope.Operation.CREATE);
        this.activityMonitoringMeter.onEvent((DataCollectionId)TableId.parse((String)"db.schema.anotherTable"), null, (Object)1L, null, Envelope.Operation.TRUNCATE);
        this.activityMonitoringMeter.reset();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfCreateEventsSeen()).isEmpty();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfUpdateEventsSeen()).isEmpty();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfDeleteEventsSeen()).isEmpty();
        Assertions.assertThat((Map)this.activityMonitoringMeter.getNumberOfTruncateEventsSeen()).isEmpty();
    }
}

