/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.snapshot.Snapshotter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.kafka.connect.source.SourceConnector;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ChangeEventSourceCoordinatorTest {
    SnapshotterService snapshotterService;
    Snapshotter snapshotter;
    CommonConnectorConfig connectorConfig;
    ChangeEventSourceCoordinator coordinator;
    ChangeEventSource.ChangeEventSourceContext context;

    @Before
    public void before() {
        this.snapshotterService = (SnapshotterService)Mockito.mock(SnapshotterService.class);
        this.snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        this.connectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        Mockito.when((Object)this.connectorConfig.getLogicalName()).thenReturn((Object)"DummyConnector");
        this.coordinator = new ChangeEventSourceCoordinator(null, null, SourceConnector.class, this.connectorConfig, null, null, null, null, null, null, this.snapshotterService);
        this.context = (ChangeEventSource.ChangeEventSourceContext)Mockito.mock(ChangeEventSource.ChangeEventSourceContext.class);
    }

    @Test
    public void testNotDelayStreamingIfSnapshotShouldNotStream() throws Exception {
        Mockito.when((Object)this.snapshotterService.getSnapshotter()).thenReturn((Object)this.snapshotter);
        Mockito.when((Object)this.snapshotter.shouldStream()).thenReturn((Object)false);
        this.coordinator.delayStreamingIfNeeded(this.context);
        ((CommonConnectorConfig)Mockito.verify((Object)this.connectorConfig, (VerificationMode)Mockito.never())).getStreamingDelay();
    }

    @Test
    public void testDelayStreamingIfSnapshotShouldStream() throws Exception {
        Mockito.when((Object)this.snapshotterService.getSnapshotter()).thenReturn((Object)this.snapshotter);
        Mockito.when((Object)this.snapshotter.shouldStream()).thenReturn((Object)true);
        Mockito.when((Object)this.connectorConfig.getStreamingDelay()).thenReturn((Object)Duration.of(1L, ChronoUnit.SECONDS));
        Mockito.when((Object)this.context.isRunning()).thenReturn((Object)true);
        this.coordinator.delayStreamingIfNeeded(this.context);
        ((CommonConnectorConfig)Mockito.verify((Object)this.connectorConfig, (VerificationMode)Mockito.times((int)1))).getStreamingDelay();
    }
}

