/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.data.EnumSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class EnumSetTest {
    @Test
    public void shouldCreateSchemaBuilderFromValues() {
        this.assertBuilder(EnumSet.builder(Arrays.asList("a", "b", "c")), "a,b,c");
        this.assertBuilder(EnumSet.builder(Arrays.asList("a")), "a");
        this.assertBuilder(EnumSet.builder((List)Collections.EMPTY_LIST), "");
        this.assertBuilder(EnumSet.builder((List)null), "");
    }

    @Test
    public void shouldCreateSchemaFromValues() {
        this.assertSchema(EnumSet.schema(Arrays.asList("a", "b", "c")), "a,b,c");
        this.assertSchema(EnumSet.schema(Arrays.asList("a")), "a");
        this.assertSchema(EnumSet.schema((List)Collections.EMPTY_LIST), "");
        this.assertSchema(EnumSet.schema((List)null), "");
    }

    private void assertBuilder(SchemaBuilder builder, String expectedAllowedValues) {
        Assertions.assertThat((Object)builder).isNotNull();
        Assertions.assertThat((Map)builder.parameters()).isNotNull();
        Assertions.assertThat((String)((String)builder.parameters().get("allowed"))).isEqualTo((Object)expectedAllowedValues);
    }

    private void assertSchema(Schema schema, String expectedAllowedValues) {
        Assertions.assertThat((Object)schema).isNotNull();
        Assertions.assertThat((Map)schema.parameters()).isNotNull();
        Assertions.assertThat((String)((String)schema.parameters().get("allowed"))).isEqualTo((Object)expectedAllowedValues);
    }
}

