/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.debezium.data.Envelope;
import io.debezium.data.SchemaUtil;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractInstantAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;

public class VerifyRecord {
    private static final String APICURIO_URL = "http://localhost:8080/apis/registry/v2";
    private static final JsonConverter keyJsonConverter = new JsonConverter();
    private static final JsonConverter valueJsonConverter = new JsonConverter();
    private static final JsonDeserializer keyJsonDeserializer = new JsonDeserializer();
    private static final JsonDeserializer valueJsonDeserializer = new JsonDeserializer();
    private static final boolean useApicurio = VerifyRecord.isApucurioAvailable();
    private static Converter avroKeyConverter;
    private static Converter avroValueConverter;

    public static void isValidInsert(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assertions.assertThat((Object)record.key()).isNotNull();
            Assertions.assertThat((Object)record.keySchema()).isNotNull();
        } else {
            Assertions.assertThat((Object)record.key()).isNull();
            Assertions.assertThat((Object)record.keySchema()).isNull();
        }
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
        Assertions.assertThat((Object)value.get("before")).isNull();
    }

    public static void isValidRead(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.READ.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
        Assertions.assertThat((Object)value.get("before")).isNull();
    }

    public static void isValidUpdate(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assertions.assertThat((Object)record.key()).isNotNull();
            Assertions.assertThat((Object)record.keySchema()).isNotNull();
        } else {
            Assertions.assertThat((Object)record.key()).isNull();
            Assertions.assertThat((Object)record.keySchema()).isNull();
        }
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
    }

    public static void isValidDelete(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assertions.assertThat((Object)record.key()).isNotNull();
            Assertions.assertThat((Object)record.keySchema()).isNotNull();
        } else {
            Assertions.assertThat((Object)record.key()).isNull();
            Assertions.assertThat((Object)record.keySchema()).isNull();
        }
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
        Assertions.assertThat((Object)value.get("before")).isNotNull();
        Assertions.assertThat((Object)value.get("after")).isNull();
    }

    public static void isValidTombstone(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.value()).isNull();
        Assertions.assertThat((Object)record.valueSchema()).isNull();
    }

    public static void hasValidKey(SourceRecord record, String pkField, int pk) {
        Struct key = (Struct)record.key();
        Assertions.assertThat((Object)key.get(pkField)).isEqualTo((Object)pk);
    }

    public static void isValidInsert(SourceRecord record) {
        VerifyRecord.isValidInsert(record, false);
    }

    public static void isValidInsert(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidInsert(record, true);
    }

    public static void isValidRead(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidRead(record);
    }

    public static void isValidUpdate(SourceRecord record) {
        VerifyRecord.isValidUpdate(record, false);
    }

    public static void isValidUpdate(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidUpdate(record, true);
    }

    public static void isValidDelete(SourceRecord record) {
        VerifyRecord.isValidDelete(record, false);
    }

    public static void isValidDelete(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidDelete(record, true);
    }

    public static void isValidTruncate(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNull();
        Assertions.assertThat((Object)record.keySchema()).isNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.TRUNCATE.code());
        Assertions.assertThat((Object)value.get("before")).isNull();
        Assertions.assertThat((Object)value.get("after")).isNull();
    }

    public static void isValidTombstone(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidTombstone(record);
    }

    public static void hasValidSourceQuery(SourceRecord record, String query) {
        VerifyRecord.assertValueField(record, "source/query", query);
    }

    public static void hasNoSourceQuery(SourceRecord record) {
        VerifyRecord.hasValidSourceQuery(record, null);
    }

    public static void assertValueField(SourceRecord record, String fieldPath, Object expectedValue) {
        Object value = record.value();
        String[] fieldNames = fieldPath.split("/");
        String pathSoFar = null;
        for (int i = 0; i != fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            if (value instanceof Struct) {
                value = ((Struct)value).get(fieldName);
            } else {
                Object path = pathSoFar == null ? "record value" : "'" + pathSoFar + "'";
                String msg = "Expected the " + (String)path + " to be a Struct but was " + value.getClass().getSimpleName() + " in record: " + SchemaUtil.asString((SourceRecord)record);
                Assert.fail((String)msg);
            }
            pathSoFar = pathSoFar == null ? fieldName : pathSoFar + "/" + fieldName;
        }
        VerifyRecord.assertSameValue(value, expectedValue);
    }

    public static void assertSameValue(Object actual, Object expected) {
        if (expected instanceof Double || expected instanceof Float || expected instanceof BigDecimal) {
            double expectedNumericValue = ((Number)expected).doubleValue();
            double actualNumericValue = ((Number)actual).doubleValue();
            Assertions.assertThat((double)actualNumericValue).isEqualTo(expectedNumericValue, Assertions.offset((Double)(0.01 * expectedNumericValue)));
        } else if (expected instanceof Integer || expected instanceof Long || expected instanceof Short) {
            long expectedNumericValue = ((Number)expected).longValue();
            long actualNumericValue = ((Number)actual).longValue();
            Assertions.assertThat((long)actualNumericValue).isEqualTo(expectedNumericValue);
        } else if (expected instanceof Boolean) {
            boolean expectedValue = (Boolean)expected;
            boolean actualValue = (Boolean)actual;
            Assertions.assertThat((boolean)actualValue).isEqualTo(expectedValue);
        } else {
            Assertions.assertThat((Object)actual).isEqualTo(expected);
        }
    }

    public static void schemaMatchesStruct(SchemaAndValue schemaAndValue) {
        Object value = schemaAndValue.value();
        if (value == null) {
            Assertions.assertThat((Object)schemaAndValue.schema()).isNull();
        } else {
            Assertions.assertThat((Object)value).isInstanceOf(Struct.class);
            VerifyRecord.fieldsInSchema((Struct)value, schemaAndValue.schema());
        }
    }

    public static void schemaMatchesStruct(Struct struct, Schema schema) {
        try {
            struct.validate();
        }
        catch (DataException e) {
            throw new AssertionError("The struct '" + String.valueOf(struct) + "' failed to validate", e);
        }
        Schema actualSchema = struct.schema();
        Assertions.assertThat((Object)actualSchema).isEqualTo((Object)schema);
        VerifyRecord.fieldsInSchema(struct, schema);
    }

    public static void fieldsInSchema(Struct struct, Schema schema) {
        schema.fields().forEach(field -> {
            Object val1 = struct.get(field);
            Object val2 = struct.get(field.name());
            Assertions.assertThat((Object)val1).isSameAs(val2);
            if (val1 instanceof Struct) {
                VerifyRecord.fieldsInSchema((Struct)val1, field.schema());
            }
        });
    }

    public static void print(SourceRecord record) {
        Testing.print(SchemaUtil.asString((SourceRecord)record));
    }

    public static void debug(SourceRecord record) {
        Testing.debug(SchemaUtil.asDetailedString((SourceRecord)record));
    }

    public static void assertEquals(SourceRecord actual, SourceRecord expected, Predicate<String> ignoreFields, Map<String, RecordValueComparator> comparatorsByName, Map<String, RecordValueComparator> comparatorsBySchemaName) {
        String expectedStr;
        String actualStr;
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((Object)expected).isNotNull();
        VerifyRecord.assertEquals(null, actual.sourcePartition(), expected.sourcePartition(), "sourcePartition", "", ignoreFields, comparatorsByName, comparatorsBySchemaName);
        VerifyRecord.assertEquals(null, actual.sourceOffset(), expected.sourceOffset(), "sourceOffset", "", ignoreFields, comparatorsByName, comparatorsBySchemaName);
        Assertions.assertThat((String)actual.topic()).isEqualTo((Object)expected.topic());
        Assertions.assertThat((Integer)actual.kafkaPartition()).isEqualTo((Object)expected.kafkaPartition());
        Schema actualKeySchema = actual.keySchema();
        Schema actualValueSchema = actual.valueSchema();
        Schema expectedKeySchema = expected.keySchema();
        Schema expectedValueSchema = expected.valueSchema();
        if (!Objects.equals(actualKeySchema, expectedKeySchema)) {
            actualStr = SchemaUtil.asString((Schema)actualKeySchema);
            expectedStr = SchemaUtil.asString((Schema)expectedKeySchema);
            ((AbstractStringAssert)Assertions.assertThat((String)actualStr).as("The key schema for record with key " + SchemaUtil.asString((Object)actual.key()) + " did not match expected schema", new Object[0])).isEqualTo((Object)expectedStr);
        }
        if (!Objects.equals(actualValueSchema, expectedValueSchema)) {
            actualStr = SchemaUtil.asString((Schema)actualValueSchema);
            expectedStr = SchemaUtil.asString((Schema)expectedValueSchema);
            Assertions.assertThat((String)actualStr).isEqualTo((Object)expectedStr);
        }
        VerifyRecord.assertEquals(actualKeySchema, actual.key(), expected.key(), "key", "", ignoreFields, comparatorsByName, comparatorsBySchemaName);
        VerifyRecord.assertEquals(actualValueSchema, actual.value(), expected.value(), "value", "", ignoreFields, comparatorsByName, comparatorsBySchemaName);
    }

    public static void assertConnectSchemasAreEqual(String fieldName, Schema actual, Schema expected) {
        if (!VerifyRecord.areConnectSchemasEqual(actual, expected)) {
            ((AbstractStringAssert)Assertions.assertThat((String)SchemaUtil.asString((Schema)actual)).describedAs("field name: " + fieldName, new Object[0])).isEqualTo((Object)SchemaUtil.asString((Schema)expected));
            ((MapAssert)Assertions.assertThat((Map)actual.parameters()).describedAs("field '" + fieldName + "' parameters", new Object[0])).isEqualTo((Object)expected.parameters());
            Assert.fail((String)("field '" + fieldName + "': " + SchemaUtil.asString((Schema)actual) + " was not equal to " + SchemaUtil.asString((Schema)expected)));
        }
    }

    protected static String nameOf(String keyOrValue, String field) {
        if (field == null || field.trim().isEmpty()) {
            return keyOrValue;
        }
        return "'" + field + "' field in the record " + keyOrValue;
    }

    private static String fieldName(String field, String suffix) {
        if (field == null || field.trim().isEmpty()) {
            return suffix;
        }
        return field + "/" + suffix;
    }

    private static String schemaName(Schema schema) {
        if (schema == null) {
            return null;
        }
        String name = schema.name();
        if (name != null) {
            name = name.trim();
        }
        return name == null || name.isEmpty() ? null : name;
    }

    protected static void assertEquals(Schema schema, Object o1, Object o2, String keyOrValue, String field, Predicate<String> ignoreFields, Map<String, RecordValueComparator> comparatorsByName, Map<String, RecordValueComparator> comparatorsBySchemaName) {
        if (o1 == o2) {
            return;
        }
        if (o1 == null) {
            if (o2 == null) {
                return;
            }
            Assert.fail((String)(VerifyRecord.nameOf(keyOrValue, field) + " was null but expected " + SchemaUtil.asString((Object)o2)));
        } else if (o2 == null) {
            Assert.fail((String)("expecting a null " + VerifyRecord.nameOf(keyOrValue, field) + " but found " + SchemaUtil.asString((Object)o1)));
        }
        String pathToField = keyOrValue.toUpperCase() + "/" + field;
        RecordValueComparator comparator = comparatorsByName.get(pathToField);
        if (comparator != null) {
            comparator.assertEquals(VerifyRecord.nameOf(keyOrValue, field), o1, o2);
            return;
        }
        String schemaName = VerifyRecord.schemaName(schema);
        if (schemaName != null && (comparator = comparatorsBySchemaName.get(schemaName)) != null) {
            comparator.assertEquals(VerifyRecord.nameOf(keyOrValue, field), o1, o2);
        }
        if (o1 instanceof ByteBuffer) {
            o1 = ((ByteBuffer)o1).array();
        }
        if (o2 instanceof ByteBuffer) {
            o2 = ((ByteBuffer)o2).array();
        }
        if (o2 instanceof byte[]) {
            if (!(o1 instanceof byte[])) {
                Assert.fail((String)("expecting " + VerifyRecord.nameOf(keyOrValue, field) + " to be byte[] but found " + o1.getClass().toString()));
            }
            if (!Arrays.equals((byte[])o1, (byte[])o2)) {
                Assert.fail((String)("byte[] at " + VerifyRecord.nameOf(keyOrValue, field) + " is " + String.valueOf(o1) + " but was expected to be " + String.valueOf(o2)));
            }
        } else if (o2 instanceof Object[]) {
            if (!(o1 instanceof Object[])) {
                Assert.fail((String)("expecting " + VerifyRecord.nameOf(keyOrValue, field) + " to be Object[] but was " + o1.getClass().toString()));
            }
            if (!VerifyRecord.deepEquals((Object[])o1, (Object[])o2)) {
                Assert.fail((String)("Object[] at " + VerifyRecord.nameOf(keyOrValue, field) + " is " + String.valueOf(o1) + " but was expected to be " + String.valueOf(o2)));
            }
        } else if (o2 instanceof Map) {
            if (!(o1 instanceof Map)) {
                Assert.fail((String)("expecting " + VerifyRecord.nameOf(keyOrValue, field) + " to be Map<String,?> but was " + o1.getClass().toString()));
            }
            Map m1 = (Map)o1;
            Map m2 = (Map)o2;
            if (!m1.keySet().equals(m2.keySet())) {
                Assert.fail((String)("Map at " + VerifyRecord.nameOf(keyOrValue, field) + " has entry keys " + String.valueOf(m1.keySet()) + " but expected " + String.valueOf(m2.keySet())));
            }
            for (Map.Entry entry : m1.entrySet()) {
                String key = (String)entry.getKey();
                String fieldName = field.isEmpty() ? key : field + "/" + key;
                String predicate = keyOrValue.toUpperCase() + "/" + fieldName;
                if (ignoreFields != null && ignoreFields.test(predicate)) continue;
                Object v1 = entry.getValue();
                Object v2 = m2.get(key);
                VerifyRecord.assertEquals(null, v1, v2, keyOrValue, VerifyRecord.fieldName(field, key), ignoreFields, comparatorsByName, comparatorsBySchemaName);
            }
        } else if (o2 instanceof Collection) {
            if (!(o1 instanceof Collection)) {
                Assert.fail((String)("expecting " + VerifyRecord.nameOf(keyOrValue, field) + " to be Collection<?> but was " + o1.getClass().toString()));
            }
            Collection m1 = (Collection)o1;
            Collection m2 = (Collection)o2;
            if (m1.size() != m2.size()) {
                Assert.fail((String)("Collection at " + VerifyRecord.nameOf(keyOrValue, field) + " has " + SchemaUtil.asString((Object)m1) + " but expected " + SchemaUtil.asString((Object)m2)));
            }
            Iterator iter1 = m1.iterator();
            Iterator iter2 = m2.iterator();
            int index = 0;
            while (iter1.hasNext() && iter2.hasNext()) {
                VerifyRecord.assertEquals(null, iter1.next(), iter2.next(), keyOrValue, field + "[" + index++ + "]", ignoreFields, comparatorsByName, comparatorsBySchemaName);
            }
        } else {
            if (o2 instanceof Struct) {
                if (!(o1 instanceof Struct)) {
                    Assert.fail((String)("expecting " + VerifyRecord.nameOf(keyOrValue, field) + " to be Struct but was " + o1.getClass().toString()));
                }
                Struct struct1 = (Struct)o1;
                Struct struct2 = (Struct)o2;
                if (!Objects.equals(struct1.schema(), struct2.schema())) {
                    Assert.fail((String)("Schema at " + VerifyRecord.nameOf(keyOrValue, field) + " is " + SchemaUtil.asString((Schema)struct1.schema()) + " but expected " + SchemaUtil.asString((Schema)struct2.schema())));
                }
                for (Field f : struct1.schema().fields()) {
                    String fieldName = VerifyRecord.fieldName(field, f.name());
                    String predicate = keyOrValue.toUpperCase() + "/" + fieldName;
                    if (ignoreFields != null && ignoreFields.test(predicate)) continue;
                    Object value1 = struct1.get(f);
                    Object value2 = struct2.get(f);
                    VerifyRecord.assertEquals(f.schema(), value1, value2, keyOrValue, fieldName, ignoreFields, comparatorsByName, comparatorsBySchemaName);
                }
                return;
            }
            if (o2 instanceof Double || o2 instanceof Float || o2 instanceof BigDecimal) {
                double expectedNumericValue = ((Number)o2).doubleValue();
                double actualNumericValue = ((Number)o1).doubleValue();
                String desc = "found " + VerifyRecord.nameOf(keyOrValue, field) + " is " + String.valueOf(o1) + " but expected " + String.valueOf(o2);
                ((AbstractDoubleAssert)Assertions.assertThat((double)actualNumericValue).as(desc, new Object[0])).isEqualTo(expectedNumericValue, Assertions.offset((Double)(0.01 * expectedNumericValue)));
            } else if (o2 instanceof Integer || o2 instanceof Long || o2 instanceof Short) {
                long expectedNumericValue = ((Number)o2).longValue();
                long actualNumericValue = ((Number)o1).longValue();
                String desc = "found " + VerifyRecord.nameOf(keyOrValue, field) + " is " + String.valueOf(o1) + " but expected " + String.valueOf(o2);
                ((AbstractLongAssert)Assertions.assertThat((long)actualNumericValue).as(desc, new Object[0])).isEqualTo(expectedNumericValue);
            } else if (o2 instanceof Boolean) {
                boolean expectedValue = (Boolean)o2;
                boolean actualValue = (Boolean)o1;
                String desc = "found " + VerifyRecord.nameOf(keyOrValue, field) + " is " + String.valueOf(o1) + " but expected " + String.valueOf(o2);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualValue).as(desc, new Object[0])).isEqualTo(expectedValue);
            } else if ("io.debezium.time.ZonedTimestamp".equals(schemaName)) {
                ZonedDateTime expectedValue;
                String actualValueString = o1.toString();
                ZonedDateTime actualValue = ZonedDateTime.parse(o1.toString(), ZonedTimestamp.FORMATTER);
                String expectedValueString = o2.toString();
                try {
                    expectedValue = ZonedDateTime.parse(expectedValueString, ZonedTimestamp.FORMATTER);
                }
                catch (DateTimeParseException e) {
                    LocalDateTime localDateTime = LocalDateTime.parse(expectedValueString);
                    expectedValue = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
                }
                ((AbstractInstantAssert)((AbstractInstantAssert)Assertions.assertThat((Instant)actualValue.toInstant()).as(actualValueString, new Object[0])).isEqualTo((Object)expectedValue.toInstant())).as(expectedValueString, new Object[0]);
            } else {
                Assertions.assertThat((Object)o1).isEqualTo(o2);
            }
        }
    }

    public static void isValid(SourceRecord record) {
        VerifyRecord.isValid(record, false);
    }

    public static void isValid(SourceRecord record, boolean ignoreAvro) {
        JsonNode keyJson = null;
        JsonNode valueJson = null;
        SchemaAndValue keyWithSchema = null;
        SchemaAndValue valueWithSchema = null;
        SchemaAndValue avroKeyWithSchema = null;
        SchemaAndValue avroValueWithSchema = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "serializing key using JSON converter";
            byte[] keyBytes = keyJsonConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            msg = "deserializing key using JSON deserializer";
            keyJson = keyJsonDeserializer.deserialize(record.topic(), keyBytes);
            msg = "deserializing key using JSON converter";
            keyWithSchema = keyJsonConverter.toConnectData(record.topic(), keyBytes);
            msg = "comparing key schema to that serialized/deserialized with JSON converter";
            Assertions.assertThat((Object)keyWithSchema.schema()).isEqualTo((Object)record.keySchema());
            msg = "comparing key to that serialized/deserialized with JSON converter";
            Assertions.assertThat((Object)keyWithSchema.value()).isEqualTo(record.key());
            msg = "comparing key to its schema";
            VerifyRecord.schemaMatchesStruct(keyWithSchema);
            msg = "serializing value using JSON converter";
            byte[] valueBytes = valueJsonConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using JSON deserializer";
            valueJson = valueJsonDeserializer.deserialize(record.topic(), valueBytes);
            msg = "deserializing value using JSON converter";
            valueWithSchema = valueJsonConverter.toConnectData(record.topic(), valueBytes);
            msg = "comparing value schema to that serialized/deserialized with JSON converter";
            VerifyRecord.assertEquals(valueWithSchema.schema(), record.valueSchema());
            msg = "comparing value to that serialized/deserialized with JSON converter";
            VerifyRecord.assertEquals(valueWithSchema.value(), record.value());
            msg = "comparing value to its schema";
            VerifyRecord.schemaMatchesStruct(valueWithSchema);
            if (ignoreAvro) {
                return;
            }
            VerifyRecord.validateSchemaNames(record.keySchema());
            VerifyRecord.validateSchemaNames(record.valueSchema());
            msg = "serializing key using Avro converter";
            byte[] avroKeyBytes = avroValueConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            msg = "deserializing key using Avro converter";
            avroKeyWithSchema = avroValueConverter.toConnectData(record.topic(), avroKeyBytes);
            msg = "comparing key schema to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(VerifyRecord.setVersion(avroKeyWithSchema.schema(), null), VerifyRecord.setVersion(record.keySchema(), null));
            msg = "comparing key to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(VerifyRecord.setVersion(avroKeyWithSchema, null).value(), VerifyRecord.setVersion(record.key(), null));
            msg = "comparing key to its schema";
            VerifyRecord.schemaMatchesStruct(avroKeyWithSchema);
            msg = "serializing value using Avro converter";
            byte[] avroValueBytes = avroValueConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using Avro converter";
            avroValueWithSchema = avroValueConverter.toConnectData(record.topic(), avroValueBytes);
            msg = "comparing value schema to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(VerifyRecord.setVersion(avroValueWithSchema.schema(), null), VerifyRecord.setVersion(record.valueSchema(), null));
            msg = "comparing value to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(VerifyRecord.setVersion(avroValueWithSchema, null).value(), VerifyRecord.setVersion(record.value(), null));
            msg = "comparing value to its schema";
            VerifyRecord.schemaMatchesStruct(avroValueWithSchema);
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  key: " + SchemaUtil.asString((Object)record.key()));
            Testing.print("  key deserialized from JSON: " + VerifyRecord.prettyJson(keyJson));
            if (keyWithSchema != null) {
                Testing.print("  key to/from JSON: " + SchemaUtil.asString((Object)keyWithSchema.value()));
            }
            if (avroKeyWithSchema != null) {
                Testing.print("  key to/from Avro: " + SchemaUtil.asString((Object)avroKeyWithSchema.value()));
            }
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            Testing.print("  value deserialized from JSON: " + VerifyRecord.prettyJson(valueJson));
            if (valueWithSchema != null) {
                Testing.print("  value to/from JSON: " + SchemaUtil.asString((Object)valueWithSchema.value()));
            }
            if (avroValueWithSchema != null) {
                Testing.print("  value to/from Avro: " + SchemaUtil.asString((Object)avroValueWithSchema.value()));
            }
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    protected static void validateSchemaNames(Schema schema) {
        if (schema == null) {
            return;
        }
        String schemaName = schema.name();
        if (schemaName != null && !SchemaNameAdjuster.isValidFullname((String)schemaName)) {
            Assert.fail((String)("Kafka schema '" + schemaName + "' is not a valid Avro schema name"));
        }
        if (schema.type() == Schema.Type.STRUCT) {
            schema.fields().forEach(field -> VerifyRecord.validateSubSchemaNames(schema, field));
        }
    }

    protected static void validateSubSchemaNames(Schema parentSchema, Field field) {
        if (field == null) {
            return;
        }
        Schema subSchema = field.schema();
        String subSchemaName = subSchema.name();
        if (subSchemaName != null && !SchemaNameAdjuster.isValidFullname((String)subSchemaName)) {
            Assert.fail((String)("Kafka schema '" + parentSchema.name() + "' contains a subschema for '" + field.name() + "' named '" + subSchema.name() + "' that is not a valid Avro schema name"));
        }
        if (subSchema.type() == Schema.Type.STRUCT) {
            subSchema.fields().forEach(child -> VerifyRecord.validateSubSchemaNames(parentSchema, child));
        }
    }

    protected static void printJson(SourceRecord record) {
        JsonNode keyJson = null;
        JsonNode valueJson = null;
        try {
            byte[] keyBytes = keyJsonConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            keyJson = keyJsonDeserializer.deserialize(record.topic(), keyBytes);
            byte[] valueBytes = valueJsonConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            valueJson = valueJsonDeserializer.deserialize(record.topic(), valueBytes);
            JsonNodeFactory nodeFactory = new JsonNodeFactory(false);
            ObjectNode message = nodeFactory.objectNode();
            message.set("key", keyJson);
            message.set("value", valueJson);
            Testing.print("Message on topic '" + record.topic() + "':");
            Testing.print(VerifyRecord.prettyJson((JsonNode)message));
        }
        catch (Throwable t) {
            Testing.printError(t);
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            if (keyJson != null) {
                Testing.print("valid key = " + VerifyRecord.prettyJson(keyJson));
            } else {
                Testing.print("invalid key");
            }
            if (valueJson != null) {
                Testing.print("valid value = " + VerifyRecord.prettyJson(valueJson));
            } else {
                Testing.print("invalid value");
            }
            Assert.fail((String)t.getMessage());
        }
    }

    protected static String prettyJson(JsonNode json) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        }
        catch (Throwable t) {
            Testing.printError(t);
            Assert.fail((String)t.getMessage());
            assert (false) : "Will not get here";
            return null;
        }
    }

    protected static void assertEquals(Object o1, Object o2) {
        if (o1 instanceof Schema && o2 instanceof Schema) {
            VerifyRecord.assertConnectSchemasAreEqual(null, (Schema)o1, (Schema)o2);
        } else if (!VerifyRecord.equals(o1, o2)) {
            Assert.fail((String)(SchemaUtil.asString((Object)o1) + " was not equal to " + SchemaUtil.asString((Object)o2)));
        }
    }

    protected static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof ByteBuffer) {
            o1 = ((ByteBuffer)o1).array();
        }
        if (o2 instanceof ByteBuffer) {
            o2 = ((ByteBuffer)o2).array();
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            boolean result = Arrays.equals((byte[])o1, (byte[])o2);
            return result;
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            boolean result = VerifyRecord.deepEquals((Object[])o1, (Object[])o2);
            return result;
        }
        if (o1 instanceof Map && o2 instanceof Map) {
            Map m1 = (Map)o1;
            Map m2 = (Map)o2;
            if (!m1.keySet().equals(m2.keySet())) {
                return false;
            }
            for (Map.Entry entry : m1.entrySet()) {
                Object v2;
                Object v1 = entry.getValue();
                if (VerifyRecord.equals(v1, v2 = m2.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Collection && o2 instanceof Collection) {
            Collection m1 = (Collection)o1;
            Collection m2 = (Collection)o2;
            if (m1.size() != m2.size()) {
                return false;
            }
            Iterator iter1 = m1.iterator();
            Iterator iter2 = m2.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (VerifyRecord.equals(iter1.next(), iter2.next())) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Struct && o2 instanceof Struct) {
            Struct struct1 = (Struct)o1;
            Struct struct2 = (Struct)o2;
            if (!VerifyRecord.areConnectSchemasEqual(struct1.schema(), struct2.schema())) {
                return false;
            }
            Object[] array1 = VerifyRecord.valuesFor(struct1);
            Object[] array2 = VerifyRecord.valuesFor(struct2);
            return VerifyRecord.deepEquals(array1, array2);
        }
        if (o1 instanceof ConnectSchema && o1 instanceof ConnectSchema) {
            return VerifyRecord.areConnectSchemasEqual((Schema)((ConnectSchema)o1), (Schema)((ConnectSchema)o2));
        }
        return Objects.equals(o1, o2);
    }

    private static Object[] valuesFor(Struct struct) {
        Object[] array = new Object[struct.schema().fields().size()];
        int index = 0;
        for (Field field : struct.schema().fields()) {
            array[index] = struct.get(field);
            ++index;
        }
        return array;
    }

    private static boolean deepEquals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            boolean eq = VerifyRecord.deepEquals0(e1, e2);
            if (eq) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEquals0(Object e1, Object e2) {
        assert (e1 != null);
        boolean eq = e1 instanceof Object[] && e2 instanceof Object[] ? VerifyRecord.deepEquals((Object[])e1, (Object[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? Arrays.equals((byte[])e1, (byte[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? Arrays.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? Arrays.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? Arrays.equals((long[])e1, (long[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? Arrays.equals((char[])e1, (char[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? Arrays.equals((float[])e1, (float[])e2) : (e1 instanceof double[] && e2 instanceof double[] ? Arrays.equals((double[])e1, (double[])e2) : (e1 instanceof boolean[] && e2 instanceof boolean[] ? Arrays.equals((boolean[])e1, (boolean[])e2) : VerifyRecord.equals(e1, e2)))))))));
        return eq;
    }

    private static boolean areConnectSchemasEqual(Schema schema1, Schema schema2) {
        boolean equal;
        if (schema1 == schema2) {
            return true;
        }
        if (schema1 == null && schema2 != null || schema1 != null && schema2 == null) {
            return false;
        }
        if (schema1.getClass() != schema2.getClass()) {
            return false;
        }
        boolean keySchemasEqual = true;
        boolean valueSchemasEqual = true;
        boolean fieldsEqual = true;
        if (schema1.type() == Schema.Type.MAP && schema2.type() == Schema.Type.MAP) {
            keySchemasEqual = Objects.equals(schema1.keySchema(), schema2.keySchema());
            valueSchemasEqual = Objects.equals(schema1.valueSchema(), schema2.valueSchema());
        } else if (schema1.type() == Schema.Type.ARRAY && schema2.type() == Schema.Type.ARRAY) {
            valueSchemasEqual = VerifyRecord.areConnectSchemasEqual(schema1.valueSchema(), schema2.valueSchema());
        } else if (schema1.type() == Schema.Type.STRUCT && schema2.type() == Schema.Type.STRUCT) {
            fieldsEqual = VerifyRecord.areFieldListsEqual(schema1.fields(), schema2.fields());
        }
        boolean bl = equal = Objects.equals(schema1.isOptional(), schema2.isOptional()) && Objects.equals(schema1.version(), schema2.version()) && Objects.equals(schema1.name(), schema2.name()) && Objects.equals(schema1.doc(), schema2.doc()) && Objects.equals(schema1.type(), schema2.type()) && fieldsEqual && keySchemasEqual && valueSchemasEqual && Objects.equals(schema1.parameters(), schema2.parameters());
        if (equal) {
            Object default1 = schema1.defaultValue();
            Object default2 = schema2.defaultValue();
            if (default1 instanceof ByteBuffer && default2 instanceof byte[]) {
                default1 = ((ByteBuffer)default1).array();
            }
            if (default1 instanceof byte[] && default2 instanceof ByteBuffer) {
                default2 = ((ByteBuffer)default2).array();
            }
            equal = Objects.deepEquals(default1, default2);
        }
        return equal;
    }

    private static boolean areFieldListsEqual(List<Field> fields1, List<Field> fields2) {
        if (fields1 == null && fields2 != null || fields1 != null && fields2 == null) {
            return false;
        }
        if (fields1.size() != fields2.size()) {
            return false;
        }
        for (int i = 0; i < fields1.size(); ++i) {
            boolean equal;
            Field field1 = fields1.get(i);
            Field field2 = fields2.get(i);
            boolean bl = equal = Objects.equals(field1.index(), field2.index()) && Objects.equals(field1.name(), field2.name()) && VerifyRecord.areConnectSchemasEqual(field1.schema(), field2.schema());
            if (equal) continue;
            return false;
        }
        return true;
    }

    private static Schema setVersion(Schema schema, Integer version) {
        if (schema == null) {
            return null;
        }
        SchemaBuilder builder = new SchemaBuilder(schema.type()).name(schema.name()).version(version).doc(schema.doc());
        if (schema.defaultValue() != null) {
            builder.defaultValue(schema.defaultValue());
        }
        if (schema.isOptional()) {
            builder.optional();
        }
        if (schema.parameters() != null) {
            builder.parameters(schema.parameters());
        }
        if (schema.fields() != null) {
            for (Field f : schema.fields()) {
                builder.field(f.name(), f.schema());
            }
        }
        return builder.build();
    }

    private static SchemaAndValue setVersion(SchemaAndValue value, Integer version) {
        Schema schema = VerifyRecord.setVersion(value.schema(), version);
        if (schema == null) {
            return value;
        }
        if (schema.type() != Schema.Type.STRUCT) {
            return new SchemaAndValue(schema, (Object)value);
        }
        Struct struct = new Struct(schema);
        Struct old = (Struct)value.value();
        for (Field f : schema.fields()) {
            struct.put(f, old.getWithoutDefault(f.name()));
        }
        return new SchemaAndValue(schema, (Object)struct);
    }

    private static Object setVersion(Object obj, Integer version) {
        if (!(obj instanceof Struct)) {
            return obj;
        }
        Struct value = (Struct)obj;
        Schema schema = VerifyRecord.setVersion(value.schema(), version);
        if (schema == null) {
            return value;
        }
        if (schema.type() != Schema.Type.STRUCT) {
            return value;
        }
        Struct struct = new Struct(schema);
        Struct old = value;
        for (Field f : schema.fields()) {
            struct.put(f, old.getWithoutDefault(f.name()));
        }
        return struct;
    }

    public static boolean isApucurioAvailable() {
        String useApicurio = System.getProperty("use.apicurio");
        return useApicurio != null && useApicurio.equalsIgnoreCase("true");
    }

    static {
        if (useApicurio) {
            avroKeyConverter = new io.apicurio.registry.utils.converter.AvroConverter();
            avroValueConverter = new io.apicurio.registry.utils.converter.AvroConverter();
        } else {
            MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
            avroKeyConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);
            avroValueConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("schemas.enable", Boolean.TRUE.toString());
        config.put("schemas.cache.size", String.valueOf(100));
        keyJsonConverter.configure(config, true);
        keyJsonDeserializer.configure(config, true);
        valueJsonConverter.configure(config, false);
        valueJsonDeserializer.configure(config, false);
        config = new HashMap();
        if (useApicurio) {
            config.put("apicurio.registry.url", APICURIO_URL);
            config.put("apicurio.registry.auto-register", true);
            config.put("apicurio.registry.find-latest", true);
            config.put("apicurio.registry.check-period-ms", 1000);
        } else {
            config.put("schema.registry.url", "http://fake-url");
        }
        avroKeyConverter.configure(config, false);
        avroValueConverter.configure(config, false);
    }

    @FunctionalInterface
    public static interface RecordValueComparator {
        public void assertEquals(String var1, Object var2, Object var3);
    }
}

