/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class AnnotationBasedTestRule
implements TestRule {
    protected static Statement emptyStatement(final String reason, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                StringBuilder messageBuilder = new StringBuilder(description.testCount());
                messageBuilder.append("Skipped ").append(description);
                if (reason != null && !reason.trim().isEmpty()) {
                    messageBuilder.append(" because: ").append(reason);
                }
                System.out.println(messageBuilder);
            }
        };
    }

    protected <T extends Annotation> T hasAnnotation(Description description, Class<T> annotationClass) {
        Annotation annotation = description.getAnnotation(annotationClass);
        if (annotation != null) {
            return (T)annotation;
        }
        if (description.isTest() && description.getTestClass().isAnnotationPresent(annotationClass)) {
            return description.getTestClass().getAnnotation(annotationClass);
        }
        if (description.isTest()) {
            for (Method method : description.getTestClass().getMethods()) {
                if (!method.getName().equals(description.getMethodName()) || !method.getDeclaringClass().isAnnotationPresent(annotationClass)) continue;
                return method.getDeclaringClass().getAnnotation(annotationClass);
            }
        }
        return null;
    }
}

