/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.notification;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.notification.IncrementalSnapshotNotificationService;
import io.debezium.pipeline.notification.Notification;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.snapshot.incremental.DataCollection;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class IncrementalSnapshotNotificationServiceTest {
    @Mock
    private Partition partition;
    @Mock
    private OffsetContext offsetContext;
    @Mock
    private NotificationService<Partition, OffsetContext> notificationService;
    @Mock
    private IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    @Mock
    private CommonConnectorConfig connectorConfig;
    private final Clock clock = Clock.fixed(Instant.parse("2023-05-17T01:25:00.00Z"), ZoneId.of("UTC"));
    private IncrementalSnapshotNotificationService<Partition, OffsetContext> incrementalSnapshotNotificationService;

    @Before
    public void setUp() {
        Mockito.when((Object)this.connectorConfig.getLogicalName()).thenReturn((Object)"connector-test");
        Mockito.when((Object)this.incrementalSnapshotContext.getCorrelationId()).thenReturn((Object)"12345");
        Mockito.when((Object)this.incrementalSnapshotContext.getDataCollections()).thenReturn(List.of(new DataCollection((Object)new TableId("db", "inventory", "product")), new DataCollection((Object)new TableId("db", "inventory", "customer"))));
        Mockito.when((Object)this.incrementalSnapshotContext.currentDataCollectionId()).thenReturn((Object)new DataCollection((Object)new TableId("db", "inventory", "product")));
        Mockito.when((Object)this.incrementalSnapshotContext.maximumKey()).thenReturn(Optional.of(new Object[]{100, 0, 0}));
        Mockito.when((Object)this.incrementalSnapshotContext.chunkEndPosititon()).thenReturn((Object)new Object[]{50, 0, 0});
        this.incrementalSnapshotNotificationService = new IncrementalSnapshotNotificationService(this.notificationService, this.connectorConfig, this.clock);
    }

    @Test
    public void notifyStarted() {
        this.incrementalSnapshotNotificationService.notifyStarted(this.incrementalSnapshotContext, this.partition, this.offsetContext);
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "STARTED", Map.of("connector_name", "connector-test", "data_collections", "db.inventory.product,db.inventory.customer"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }

    @Test
    public void notifyPaused() {
        this.incrementalSnapshotNotificationService.notifyPaused(this.incrementalSnapshotContext, this.partition, this.offsetContext);
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "PAUSED", Map.of("connector_name", "connector-test", "data_collections", "db.inventory.product,db.inventory.customer"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }

    @Test
    public void notifyResumed() {
        this.incrementalSnapshotNotificationService.notifyResumed(this.incrementalSnapshotContext, this.partition, this.offsetContext);
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "RESUMED", Map.of("connector_name", "connector-test", "data_collections", "db.inventory.product,db.inventory.customer"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }

    @Test
    public void notifyAborted() {
        this.incrementalSnapshotNotificationService.notifyAborted(this.incrementalSnapshotContext, this.partition, this.offsetContext);
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "ABORTED", Map.of("connector_name", "connector-test"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }

    @Test
    public void testNotifyAborted() {
        this.incrementalSnapshotNotificationService.notifyAborted(this.incrementalSnapshotContext, this.partition, this.offsetContext, List.of("db.inventory.product"));
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "ABORTED", Map.of("connector_name", "connector-test", "data_collections", "db.inventory.product"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }

    @Test
    public void notifyTableScanCompleted() {
        this.incrementalSnapshotNotificationService.notifyTableScanCompleted(this.incrementalSnapshotContext, this.partition, this.offsetContext, 100L, IncrementalSnapshotNotificationService.TableScanCompletionStatus.SUCCEEDED);
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "TABLE_SCAN_COMPLETED", Map.of("connector_name", "connector-test", "data_collections", "db.inventory.product,db.inventory.customer", "scanned_collection", "db.inventory.product", "total_rows_scanned", "100", "status", "SUCCEEDED"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }

    @Test
    public void notifyInProgress() {
        this.incrementalSnapshotNotificationService.notifyInProgress(this.incrementalSnapshotContext, this.partition, this.offsetContext);
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "IN_PROGRESS", Map.of("connector_name", "connector-test", "data_collections", "db.inventory.product,db.inventory.customer", "current_collection_in_progress", "db.inventory.product", "maximum_key", "100", "last_processed_key", "50"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }

    @Test
    public void notifyCompleted() {
        this.incrementalSnapshotNotificationService.notifyCompleted(this.incrementalSnapshotContext, this.partition, this.offsetContext);
        Notification expectedNotification = new Notification("12345", "Incremental Snapshot", "COMPLETED", Map.of("connector_name", "connector-test"), Long.valueOf(this.clock.millis()));
        ((NotificationService)Mockito.verify(this.notificationService)).notify((Notification)ArgumentMatchers.eq((Object)expectedNotification), (Offsets)ArgumentMatchers.any(Offsets.class));
    }
}

