/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.txmetadata;

import io.debezium.config.Configuration;
import io.debezium.pipeline.txmetadata.AbstractTransactionStructMaker;
import io.debezium.pipeline.txmetadata.DefaultTransactionStructMaker;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DefaultTransactionStructMakerTest {
    @Test
    public void getTransactionBlockSchema() {
        Schema expectedSchema = DefaultTransactionStructMaker.TRANSACTION_BLOCK_SCHEMA;
        DefaultTransactionStructMaker transactionStructMaker = new DefaultTransactionStructMaker(Configuration.empty());
        Assertions.assertThat((Object)transactionStructMaker.getTransactionBlockSchema()).isEqualTo((Object)expectedSchema);
    }

    @Test
    public void getEventCountPerDataCollectionSchema() {
        Schema expectedSchema = AbstractTransactionStructMaker.EVENT_COUNT_PER_DATA_COLLECTION_SCHEMA;
        DefaultTransactionStructMaker transactionStructMaker = new DefaultTransactionStructMaker(Configuration.empty());
        Assertions.assertThat((Object)transactionStructMaker.getEventCountPerDataCollectionSchema()).isEqualTo((Object)expectedSchema);
    }

    @Test
    public void getTransactionKeySchema() {
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.NO_OP;
        Schema expectedSchema = SchemaFactory.get().transactionKeySchema(adjuster);
        DefaultTransactionStructMaker transactionStructMaker = new DefaultTransactionStructMaker(Configuration.empty());
        Assertions.assertThat((Object)transactionStructMaker.getTransactionKeySchema()).isEqualTo((Object)expectedSchema);
    }

    @Test
    public void getTransactionValueSchema() {
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.NO_OP;
        Schema expectedSchema = SchemaFactory.get().transactionValueSchema(adjuster);
        DefaultTransactionStructMaker transactionStructMaker = new DefaultTransactionStructMaker(Configuration.empty());
        Assertions.assertThat((Object)transactionStructMaker.getTransactionValueSchema()).isEqualTo((Object)expectedSchema);
    }
}

