/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.txmetadata;

import io.debezium.pipeline.txmetadata.DefaultTransactionInfo;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.pipeline.txmetadata.TransactionInfo;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TransactionContextTest {
    @Test
    public void testGetTransactionId() {
        TransactionContext context = new TransactionContext();
        String txId = "foo";
        DefaultTransactionInfo info = new DefaultTransactionInfo(txId);
        context.beginTransaction((TransactionInfo)info);
        Assertions.assertThat((String)context.getTransactionId()).isEqualTo((Object)txId);
    }

    @Test
    public void store() {
        TransactionContext context = new TransactionContext();
        String txId = "foo";
        DefaultTransactionInfo info = new DefaultTransactionInfo(txId);
        context.beginTransaction((TransactionInfo)info);
        HashMap offsets = new HashMap();
        Map actualOffsets = context.store(offsets);
        Assertions.assertThat((Map)actualOffsets).isEqualTo(Map.of("transaction_id", txId));
    }

    @Test
    public void load() {
        String expectedId = "foo";
        Map<String, String> offsets = Map.of("transaction_id", expectedId);
        TransactionContext context = TransactionContext.load(offsets);
        Assertions.assertThat((String)context.getTransactionId()).isEqualTo((Object)expectedId);
    }

    @Test
    public void isTransactionInProgress() {
        TransactionContext context = new TransactionContext();
        String txId = "foo";
        DefaultTransactionInfo info = new DefaultTransactionInfo(txId);
        context.beginTransaction((TransactionInfo)info);
        Assertions.assertThat((boolean)context.isTransactionInProgress()).isEqualTo(true);
        context.endTransaction();
        Assertions.assertThat((boolean)context.isTransactionInProgress()).isEqualTo(false);
    }

    @Test
    public void getTotalEventCount() {
        TransactionContext context = new TransactionContext();
        String txId = "foo";
        DefaultTransactionInfo info = new DefaultTransactionInfo(txId);
        context.beginTransaction((TransactionInfo)info);
        Assertions.assertThat((long)context.getTotalEventCount()).isEqualTo(0L);
        context.event((DataCollectionId)new TableId("catalog", "schema", "table"));
        Assertions.assertThat((long)context.getTotalEventCount()).isEqualTo(1L);
    }

    @Test
    public void endTransaction() {
        TransactionContext context = new TransactionContext();
        String txId = "foo";
        DefaultTransactionInfo info = new DefaultTransactionInfo(txId);
        context.beginTransaction((TransactionInfo)info);
        Assertions.assertThat((String)context.getTransactionId()).isEqualTo((Object)txId);
        context.endTransaction();
        Assertions.assertThat((String)context.getTransactionId()).isEqualTo(null);
    }

    @Test
    public void getPerTableEventCount() {
        TransactionContext context = new TransactionContext();
        String txId = "foo";
        DefaultTransactionInfo info = new DefaultTransactionInfo(txId);
        context.beginTransaction((TransactionInfo)info);
        Assertions.assertThat((long)context.getTotalEventCount()).isEqualTo(0L);
        TableId id1 = new TableId("catalog", "schema", "table1");
        TableId id2 = new TableId("catalog", "schema", "table2");
        context.event((DataCollectionId)id1);
        context.event((DataCollectionId)id1);
        context.event((DataCollectionId)id1);
        context.event((DataCollectionId)id2);
        context.event((DataCollectionId)id2);
        Assertions.assertThat((Map)context.getPerTableEventCount()).isEqualTo(Map.of(id1.toString(), 3L, id2.toString(), 2L));
    }

    @Test
    public void testToString() {
        TransactionContext context = new TransactionContext();
        DefaultTransactionInfo info = new DefaultTransactionInfo("foo");
        context.beginTransaction((TransactionInfo)info);
        Assertions.assertThat((String)context.toString()).isEqualTo((Object)"TransactionContext [currentTransactionId=foo, perTableEventCount={}, totalEventCount=0]");
    }
}

