/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.data.Envelope;
import io.debezium.data.VerifyRecord;
import io.debezium.transforms.tracing.ActivateTracingSpan;
import io.opentelemetry.javaagent.testing.common.AgentTestingExporterAccess;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import scala.collection.mutable.StringBuilder;

public class ActivateTracingSpanTest {
    private final ActivateTracingSpan<SourceRecord> transform = new ActivateTracingSpan();
    private final String tracingSpanContextFieldName = "tracingspancontext";
    protected final Schema sourceSchema = SchemaBuilder.struct().optional().field("table", Schema.STRING_SCHEMA).field("lsn", Schema.INT32_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).build();
    protected final SchemaBuilder recordSchemaBuilder = SchemaBuilder.struct().optional().field("id", Schema.INT8_SCHEMA).field("name", Schema.STRING_SCHEMA);
    protected final Schema recordSchema = this.recordSchemaBuilder.build();
    protected final Schema recordSchemaWithTracingSpanContextField = this.recordSchemaBuilder.field("tracingspancontext", Schema.STRING_SCHEMA).build();

    @Test
    public void whenPropagationContextIsProvidedATraceIsCreated() {
        AgentTestingExporterAccess.reset();
        String propagatedTraceParent = "00-4bf92f3577b34da6a3ce929d0e0e4736-00f067aa0ba902b7-01";
        String propagatedParentId = "00f067aa0ba902b7";
        String propagatedTraceId = "4bf92f3577b34da6a3ce929d0e0e4736";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(ActivateTracingSpan.TRACING_SPAN_CONTEXT_FIELD.toString(), "tracingspancontext");
        this.transform.configure(props);
        Schema myRecordSchema = SchemaBuilder.struct().optional().field("id", Schema.INT8_SCHEMA).field("name", Schema.STRING_SCHEMA).field("tracingspancontext", Schema.STRING_SCHEMA).build();
        Struct after = new Struct(myRecordSchema);
        Struct source = new Struct(this.sourceSchema);
        source.put("table", (Object)"mytable");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)1588252618953L);
        after.put("id", (Object)1);
        after.put("name", (Object)"test");
        HashMap<String, String> tracingContext = new HashMap<String, String>();
        tracingContext.put("traceparent", "00-4bf92f3577b34da6a3ce929d0e0e4736-00f067aa0ba902b7-01");
        StringBuilder tracingContextSb = new StringBuilder();
        for (Map.Entry prop : tracingContext.entrySet()) {
            tracingContextSb.append((String)prop.getKey()).append("=").append((String)prop.getValue()).append("\n");
        }
        after.put("tracingspancontext", (Object)tracingContextSb.toString());
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(myRecordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)after, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record, true);
        SourceRecord transformedRecord = (SourceRecord)this.transform.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord, true);
        List spans = AgentTestingExporterAccess.getExportedSpans();
        Assertions.assertThat((int)spans.size()).isEqualTo(2);
        Assertions.assertThat((String)((SpanData)spans.get(0)).getName()).isEqualTo((Object)"debezium-read");
        Assertions.assertThat((String)((SpanData)spans.get(1)).getName()).isEqualTo((Object)"db-log-write");
        Assertions.assertThat((String)((SpanData)spans.get(1)).getParentSpanId()).isEqualTo((Object)"00f067aa0ba902b7");
        Assertions.assertThat((String)((SpanData)spans.get(0)).getTraceId()).isEqualTo((Object)"4bf92f3577b34da6a3ce929d0e0e4736");
        Assertions.assertThat((String)((SpanData)spans.get(1)).getTraceId()).isEqualTo((Object)"4bf92f3577b34da6a3ce929d0e0e4736");
        Headers headers = transformedRecord.headers();
        Assertions.assertThat((Iterable)headers).isNotEmpty();
        Assertions.assertThat((String)headers.lastWithName("traceparent").value().toString()).contains(new CharSequence[]{"4bf92f3577b34da6a3ce929d0e0e4736"});
        Assertions.assertThat((String)headers.lastWithName("traceparent").value().toString()).contains(new CharSequence[]{((SpanData)spans.get(1)).getSpanId()});
    }

    @Test
    public void whenPropagationContextIsNotProvidedAndContextIsNotRequiredATraceIsCreated() {
        AgentTestingExporterAccess.reset();
        HashMap props = new HashMap();
        this.transform.configure(props);
        Struct after = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        source.put("table", (Object)"mytable");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)1588252618953L);
        after.put("id", (Object)1);
        after.put("name", (Object)"test");
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)after, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record, true);
        SourceRecord transformedRecord = (SourceRecord)this.transform.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord, true);
        List spans = AgentTestingExporterAccess.getExportedSpans();
        Assertions.assertThat((int)spans.size()).isEqualTo(2);
        Assertions.assertThat((String)((SpanData)spans.get(0)).getName()).isEqualTo((Object)"debezium-read");
        Assertions.assertThat((String)((SpanData)spans.get(1)).getName()).isEqualTo((Object)"db-log-write");
        Headers headers = transformedRecord.headers();
        Assertions.assertThat((Iterable)headers).isNotEmpty();
        Assertions.assertThat((String)headers.lastWithName("traceparent").value().toString()).contains(new CharSequence[]{((SpanData)spans.get(1)).getTraceId()});
        Assertions.assertThat((String)headers.lastWithName("traceparent").value().toString()).contains(new CharSequence[]{((SpanData)spans.get(1)).getSpanId()});
    }

    @Test
    public void whenPropagationContextIsNotProvidedAndContextIsRequiredNoTraceIsCreated() {
        AgentTestingExporterAccess.reset();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(ActivateTracingSpan.TRACING_CONTEXT_FIELD_REQUIRED.toString(), "true");
        this.transform.configure(props);
        Struct after = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        source.put("table", (Object)"mytable");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)1588252618953L);
        after.put("id", (Object)1);
        after.put("name", (Object)"test");
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)after, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record, true);
        SourceRecord transformedRecord = (SourceRecord)this.transform.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord, true);
        List spans = AgentTestingExporterAccess.getExportedSpans();
        Assertions.assertThat((int)spans.size()).isEqualTo(0);
        Headers headers = transformedRecord.headers();
        Assertions.assertThat((Iterable)headers).isEmpty();
    }
}

