/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.DebeziumException;
import io.debezium.transforms.AbstractExtractStateTest;
import io.debezium.transforms.ExtractSchemaToNewRecord;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ExtractSchemaToNewRecordTest
extends AbstractExtractStateTest {
    @Test
    public void testHandleCreatedRecord() {
        SourceRecord createdRecord = this.createCreateRecord();
        try (ExtractSchemaToNewRecord transform = new ExtractSchemaToNewRecord();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)createdRecord);
            this.assertMetadataBlock(transformRecord);
        }
    }

    @Test
    public void testHandleUpdateRecord() {
        SourceRecord updatedRecord = this.createUpdateRecord();
        try (ExtractSchemaToNewRecord transform = new ExtractSchemaToNewRecord();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)updatedRecord);
            this.assertMetadataBlock(transformRecord);
        }
    }

    @Test
    public void testHandleDeletedRecord() {
        SourceRecord deletedRecord = this.createDeleteRecord();
        try (ExtractSchemaToNewRecord transform = new ExtractSchemaToNewRecord();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)deletedRecord);
            this.assertMetadataBlock(transformRecord);
        }
    }

    @Test
    public void testHandleTombstoneRecord() {
        SourceRecord tombstoneRecord = this.createTombstoneRecord();
        try (ExtractSchemaToNewRecord transform = new ExtractSchemaToNewRecord();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)tombstoneRecord);
            Assertions.assertThat((Object)transformRecord).isEqualTo((Object)tombstoneRecord);
        }
    }

    @Test
    public void testHandleTruncatedRecord() {
        SourceRecord truncateRecord = this.createTruncateRecord();
        try (ExtractSchemaToNewRecord transform = new ExtractSchemaToNewRecord();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)truncateRecord);
            Assertions.assertThat((Object)transformRecord).isEqualTo((Object)truncateRecord);
        }
    }

    @Test
    public void testHandleUpdateRecordWithoutSchemaParameters() {
        SourceRecord truncateRecord = this.createUpdateRecordWithKey();
        try (ExtractSchemaToNewRecord transform = new ExtractSchemaToNewRecord();){
            HashMap props = new HashMap();
            transform.configure(props);
            transform.apply((ConnectRecord)truncateRecord);
        }
        catch (DebeziumException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Ensure that enable configurations \"column.propagate.source.type\" or \"datatype.propagate.source.type\" and the value is set to \".*\"");
        }
    }

    private void assertMetadataBlock(SourceRecord transformRecord) {
        Struct metadata = (Struct)((Struct)transformRecord.value()).get("sourceSchema");
        Struct table = (Struct)metadata.get("table");
        List columns = (List)table.get("columns");
        Struct id = (Struct)columns.get(0);
        Struct name = (Struct)columns.get(1);
        Assertions.assertThat((Object)metadata.get("id")).isEqualTo((Object)"test_table");
        Assertions.assertThat((Object)id.get("name")).isEqualTo((Object)"id");
        Assertions.assertThat((Object)id.get("typeName")).isEqualTo((Object)"int");
        Assertions.assertThat((Object)name.get("name")).isEqualTo((Object)"name");
        Assertions.assertThat((Object)name.get("typeName")).isEqualTo((Object)"varchar");
        Assertions.assertThat((Object)name.get("length")).isEqualTo((Object)255);
    }
}

