/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.ApproximateStructSizeCalculator;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;
import org.junit.Test;

public class ApproximateStructSizeCalculatorTest {
    @Test
    public void testGetApproximateRecordSizeWithBytesStruct() {
        Schema valueSchema = SchemaBuilder.struct().field("dec", Decimal.builder((int)10).build()).build();
        SourceRecord sourceRecord = new SourceRecord(Collections.emptyMap(), Collections.emptyMap(), "dummy", valueSchema, (Object)new Struct(valueSchema).put("dec", (Object)new BigDecimal("10099999.29")));
        long actual = ApproximateStructSizeCalculator.getApproximateRecordSize((SourceRecord)sourceRecord);
        Assert.assertEquals((long)actual, (long)105L);
        valueSchema = SchemaBuilder.struct().field("bf", SchemaBuilder.bytes().build()).build();
        sourceRecord = new SourceRecord(Collections.emptyMap(), Collections.emptyMap(), "dummy", valueSchema, (Object)new Struct(valueSchema).put("bf", (Object)ByteBuffer.wrap("hello debezium".getBytes())));
        actual = ApproximateStructSizeCalculator.getApproximateRecordSize((SourceRecord)sourceRecord);
        Assert.assertEquals((long)actual, (long)115L);
    }
}

