/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.InsertField;
import org.apache.kafka.connect.transforms.ReplaceField;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectRecordUtil {
    private static final String UPDATE_DESCRIPTION = "updateDescription";
    public static final String NESTING_SEPARATOR = ".";
    public static final String ROOT_FIELD_NAME = "payload";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectRecordUtil.class);

    public static <R extends ConnectRecord<R>> ExtractField<R> extractAfterDelegate() {
        return ConnectRecordUtil.extractValueDelegate("after");
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractBeforeDelegate() {
        return ConnectRecordUtil.extractValueDelegate("before");
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractUpdateDescriptionDelegate() {
        return ConnectRecordUtil.extractValueDelegate(UPDATE_DESCRIPTION);
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractValueDelegate(String field) {
        ExtractField.Value extractField = new ExtractField.Value();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("field", field);
        extractField.configure(delegateConfig);
        return extractField;
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractKeyDelegate(String field) {
        ExtractField.Key extractField = new ExtractField.Key();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("field", field);
        extractField.configure(delegateConfig);
        return extractField;
    }

    public static <R extends ConnectRecord<R>> InsertField<R> insertStaticValueDelegate(String field, String value, boolean replaceNullWithDefault) {
        InsertField.Value insertDelegate = new InsertField.Value();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("static.field", field);
        delegateConfig.put("static.value", value);
        delegateConfig.put("replace.null.with.default", replaceNullWithDefault ? "true" : "false");
        insertDelegate.configure(delegateConfig);
        return insertDelegate;
    }

    public static <R extends ConnectRecord<R>> ReplaceField<R> dropFieldFromValueDelegate(String field) {
        ReplaceField.Value dropFieldDelegate = new ReplaceField.Value();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("exclude", field);
        dropFieldDelegate.configure(delegateConfig);
        return dropFieldDelegate;
    }

    public static <R extends ConnectRecord<R>> Flatten<R> flattenValueDelegate(String delimiter) {
        Flatten.Value recordFlattener = new Flatten.Value();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("delimiter", delimiter);
        recordFlattener.configure(delegateConfig);
        return recordFlattener;
    }

    public static Struct makeUpdatedValue(Struct originalValue, List<NewEntry> newEntries, Schema updatedSchema) {
        List<String> nestedFields = newEntries.stream().filter(e -> e.name().contains(NESTING_SEPARATOR)).map(e -> e.name()).collect(Collectors.toList());
        return ConnectRecordUtil.buildUpdatedValue(ROOT_FIELD_NAME, originalValue, newEntries, updatedSchema, nestedFields, 0);
    }

    private static Struct buildUpdatedValue(String fieldName, Struct originalValue, List<NewEntry> newEntries, Schema updatedSchema, List<String> nestedFields, int level) {
        Struct updatedValue = new Struct(updatedSchema);
        for (Field field : originalValue.schema().fields()) {
            if (originalValue.get(field) == null) continue;
            if (ConnectRecordUtil.isContainedIn(field.name(), nestedFields)) {
                Struct nestedField = Requirements.requireStruct((Object)originalValue.get(field), (String)"Nested field");
                updatedValue.put(field.name(), (Object)ConnectRecordUtil.buildUpdatedValue(field.name(), nestedField, newEntries, updatedSchema.field(field.name()).schema(), nestedFields, ++level));
                continue;
            }
            updatedValue.put(field.name(), originalValue.get(field));
        }
        for (NewEntry entry : newEntries) {
            Optional<String> fieldNameToAdd = ConnectRecordUtil.getFieldName(entry.name(), fieldName, level);
            fieldNameToAdd.ifPresent(s -> updatedValue.put(s, entry.value()));
        }
        return updatedValue;
    }

    public static Schema makeNewSchema(Schema oldSchema, List<NewEntry> newEntries) {
        List<String> nestedFields = newEntries.stream().filter(e -> e.name().contains(NESTING_SEPARATOR)).map(e -> e.name()).collect(Collectors.toList());
        return ConnectRecordUtil.buildNewSchema(ROOT_FIELD_NAME, oldSchema, newEntries, nestedFields, 0);
    }

    private static Schema buildNewSchema(String fieldName, Schema oldSchema, List<NewEntry> newEntries, List<String> nestedFields, int level) {
        if (oldSchema.type().isPrimitive()) {
            return oldSchema;
        }
        SchemaBuilder newSchemabuilder = SchemaUtil.copySchemaBasics((Schema)oldSchema, (SchemaBuilder)SchemaBuilder.struct());
        for (Field field : oldSchema.fields()) {
            if (ConnectRecordUtil.isContainedIn(field.name(), nestedFields)) {
                newSchemabuilder.field(field.name(), ConnectRecordUtil.buildNewSchema(field.name(), field.schema(), newEntries, nestedFields, ++level));
                continue;
            }
            newSchemabuilder.field(field.name(), field.schema());
        }
        LOGGER.debug("Fields copied from the old schema {}", (Object)newSchemabuilder.fields());
        for (NewEntry entry : newEntries) {
            Optional<String> currentFieldName = ConnectRecordUtil.getFieldName(entry.name(), fieldName, level);
            if (!currentFieldName.isPresent()) continue;
            newSchemabuilder = newSchemabuilder.field(currentFieldName.get(), entry.schema());
        }
        LOGGER.debug("Newly added fields {}", (Object)newSchemabuilder.fields());
        return newSchemabuilder.build();
    }

    private static Optional<String> getFieldName(String destinationFieldName, String fieldName, int level) {
        String[] nestedNames = destinationFieldName.split("\\.");
        if (ConnectRecordUtil.isRootField(fieldName, nestedNames)) {
            return Optional.of(nestedNames[0]);
        }
        if (ConnectRecordUtil.isChildrenOf(fieldName, level, nestedNames)) {
            return Optional.of(nestedNames[level]);
        }
        return Optional.empty();
    }

    private static boolean isContainedIn(String fieldName, List<String> nestedFields) {
        return nestedFields.stream().anyMatch(s -> s.contains(fieldName));
    }

    private static boolean isChildrenOf(String fieldName, int level, String[] nestedNames) {
        int parentLevel = level == 0 ? 0 : level - 1;
        return nestedNames[parentLevel].equals(fieldName);
    }

    private static boolean isRootField(String fieldName, String[] nestedNames) {
        return nestedNames.length == 1 && fieldName.equals(ROOT_FIELD_NAME);
    }

    public record NewEntry(String name, Schema schema, Object value) {
    }
}

