/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.schema.SchemaFactory;
import java.time.Instant;
import java.util.Objects;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractSourceInfoStructMaker<T extends AbstractSourceInfo>
implements SourceInfoStructMaker<T> {
    private String version;
    private String connector;
    private String serverName;

    @Override
    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.version = Objects.requireNonNull(version);
        this.serverName = connectorConfig.getLogicalName();
    }

    protected SchemaBuilder commonSchemaBuilder() {
        return SchemaFactory.get().sourceInfoSchemaBuilder();
    }

    protected Struct commonStruct(T sourceInfo) {
        SnapshotRecord snapshot;
        Instant timestamp = ((AbstractSourceInfo)sourceInfo).timestamp() == null ? Instant.now() : ((AbstractSourceInfo)sourceInfo).timestamp();
        String database = ((AbstractSourceInfo)sourceInfo).database() == null ? "" : ((AbstractSourceInfo)sourceInfo).database();
        Struct ret = new Struct(this.schema()).put("version", (Object)this.version).put("connector", (Object)this.connector).put("name", (Object)this.serverName).put("ts_ms", (Object)timestamp.toEpochMilli()).put("db", (Object)database).put("ts_us", (Object)(timestamp.getEpochSecond() * 1000000L + (long)(timestamp.getNano() / 1000))).put("ts_ns", (Object)(timestamp.getEpochSecond() * 1000000000L + (long)timestamp.getNano()));
        String sequence = ((AbstractSourceInfo)sourceInfo).sequence();
        if (sequence != null) {
            ret.put("sequence", (Object)sequence);
        }
        if ((snapshot = ((AbstractSourceInfo)sourceInfo).snapshot()) != null) {
            snapshot.toSource(ret);
        }
        return ret;
    }
}

