/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.annotation.ThreadSafe;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.util.FunctionalReadWriteLock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@ThreadSafe
public final class MemorySchemaHistory
extends AbstractSchemaHistory {
    private final List<HistoryRecord> records = new ArrayList<HistoryRecord>();
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();

    @Override
    protected void storeRecord(HistoryRecord record) {
        this.lock.write(() -> this.records.add(record));
    }

    @Override
    protected void recoverRecords(Consumer<HistoryRecord> records) {
        this.lock.write(() -> this.records.forEach(records));
    }

    @Override
    public boolean storageExists() {
        return true;
    }

    @Override
    public boolean exists() {
        return !this.records.isEmpty();
    }

    public String toString() {
        return "memory";
    }
}

