/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.processors.reselect;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.function.Predicates;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.processors.spi.PostProcessor;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.util.ByteBuffers;
import io.debezium.util.Strings;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class ReselectColumnsPostProcessor
implements PostProcessor,
BeanRegistryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReselectColumnsPostProcessor.class);
    private static final String RESELECT_COLUMNS_INCLUDE_LIST = "reselect.columns.include.list";
    private static final String RESELECT_COLUMNS_EXCLUDE_LIST = "reselect.columns.exclude.list";
    private static final String RESELECT_UNAVAILABLE_VALUES = "reselect.unavailable.values";
    private static final String RESELECT_NULL_VALUES = "reselect.null.values";
    private static final String RESELECT_USE_EVENT_KEY = "reselect.use.event.key";
    private Predicate<String> selector;
    private boolean reselectUnavailableValues;
    private boolean reselectNullValues;
    private boolean reselectUseEventKeyFields;
    private JdbcConnection jdbcConnection;
    private ValueConverterProvider valueConverterProvider;
    private String unavailableValuePlaceholder;
    private ByteBuffer unavailableValuePlaceholderBytes;
    private Map<String, String> unavailableValuePlaceholderMap;
    private String unavailableValuePlaceholderJson;
    private List<Integer> unavailablePlaceholderIntArray;
    private List<Long> unavailablePlaceholderLongArray;
    private RelationalDatabaseSchema schema;
    private RelationalDatabaseConnectorConfig connectorConfig;
    public static final io.debezium.config.Field ERROR_HANDLING_MODE = io.debezium.config.Field.create("reselect.error.handling.mode").withDisplayName("Error Handling").withGroup(io.debezium.config.Field.createGroupEntry(Field.Group.CONNECTOR, 0)).withEnum(ErrorHandlingMode.class, ErrorHandlingMode.WARN).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how to handle error in case of lookup sql failure or empty reselection: 'warn' only log the error; 'fail' fail the connector with an error message.");
    private ErrorHandlingMode errorHandlingMode;

    @Override
    public void configure(Map<String, ?> properties) {
        Configuration config = Configuration.from(properties);
        this.reselectUnavailableValues = config.getBoolean(RESELECT_UNAVAILABLE_VALUES, true);
        this.reselectNullValues = config.getBoolean(RESELECT_NULL_VALUES, true);
        this.reselectUseEventKeyFields = config.getBoolean(RESELECT_USE_EVENT_KEY, false);
        this.errorHandlingMode = ErrorHandlingMode.parse(config.getString(ERROR_HANDLING_MODE));
        this.selector = new ReselectColumnsPredicateBuilder().includeColumns(config.getString(RESELECT_COLUMNS_INCLUDE_LIST)).excludeColumns(config.getString(RESELECT_COLUMNS_EXCLUDE_LIST)).build();
        if (!this.reselectNullValues && !this.reselectUnavailableValues) {
            LOGGER.warn("Reselect post-processor disables both null and unavailable columns, no-reselection will occur.");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void apply(Object messageKey, Struct value) {
        Map<String, Object> selections;
        if (value == null) {
            LOGGER.debug("Value is not a Struct, no re-selection possible.");
            return;
        }
        if (!(messageKey instanceof Struct)) {
            LOGGER.debug("Key is not a Struct, no re-selection possible.");
            return;
        }
        Struct key = (Struct)messageKey;
        Struct after = value.getStruct("after");
        if (after == null) {
            LOGGER.debug("Value has no after field, no re-selection possible.");
            return;
        }
        String operation = value.getString("op");
        if (Envelope.Operation.READ.code().equals(operation)) {
            return;
        }
        Struct source = value.getStruct("source");
        if (source == null) {
            LOGGER.debug("Value has no source field, no re-selection possible.");
            return;
        }
        TableId tableId = this.getTableIdFromSource(source);
        if (tableId == null) {
            return;
        }
        if (this.connectorConfig.isSignalDataCollection(tableId)) {
            LOGGER.debug("Signal table '{}' events are not eligible for re-selection.", (Object)tableId);
            return;
        }
        Table table = this.schema.tableFor(tableId);
        if (table == null) {
            LOGGER.debug("Unable to locate table {} in relational model.", (Object)tableId);
            return;
        }
        List<String> requiredColumnSelections = this.getRequiredColumnSelections(tableId, after);
        if (requiredColumnSelections.isEmpty()) {
            LOGGER.debug("No columns require re-selection.");
            return;
        }
        ArrayList<String> keyColumns = new ArrayList<String>();
        ArrayList<Object> keyValues = new ArrayList<Object>();
        if (this.reselectUseEventKeyFields) {
            for (Field field : key.schema().fields()) {
                keyColumns.add(field.name());
                keyValues.add(this.resolveKeyFieldValue(key, field));
            }
        } else {
            for (Column column : table.primaryKeyColumns()) {
                keyColumns.add(column.name());
                keyValues.add(this.resolveKeyFieldValue(after, after.schema().field(column.name())));
            }
        }
        try {
            selections = this.jdbcConnection.reselectColumns(table, requiredColumnSelections, keyColumns, keyValues, source);
            if (selections.isEmpty()) {
                if (this.errorHandlingMode == ErrorHandlingMode.FAIL) {
                    throw new DebeziumException("Failed to find row in table " + String.valueOf(tableId) + " with key " + String.valueOf(key));
                }
                LOGGER.warn("Failed to find row in table {} with key {}.", (Object)tableId, (Object)key);
                return;
            }
        }
        catch (SQLException e) {
            if (this.errorHandlingMode == ErrorHandlingMode.FAIL) {
                throw new DebeziumException("Failed to re-select columns for table " + String.valueOf(tableId) + " and key " + String.valueOf(keyValues), (Throwable)e);
            }
            LOGGER.warn("Failed to re-select columns for table {} and key {}", new Object[]{tableId, keyValues, e});
            return;
        }
        for (Map.Entry<String, Object> selection : selections.entrySet()) {
            String columnName = selection.getKey();
            Column column = table.columnWithName(columnName);
            Field field = after.schema().field(columnName);
            Object convertedValue = this.getConvertedValue(column, field, selection.getValue());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Replaced field {} value {} with {}", new Object[]{field.name(), value.get(field), convertedValue});
            }
            after.put(field.name(), convertedValue);
        }
    }

    @Override
    public void injectBeanRegistry(BeanRegistry beanRegistry) {
        this.connectorConfig = beanRegistry.lookupByName("ConnectorConfig", RelationalDatabaseConnectorConfig.class);
        this.unavailableValuePlaceholder = new String(this.connectorConfig.getUnavailableValuePlaceholder());
        this.unavailableValuePlaceholderBytes = ByteBuffer.wrap(this.connectorConfig.getUnavailableValuePlaceholder());
        this.unavailableValuePlaceholderMap = Map.of(this.unavailableValuePlaceholder, this.unavailableValuePlaceholder);
        this.unavailableValuePlaceholderJson = "{\"" + this.unavailableValuePlaceholder + "\":\"" + this.unavailableValuePlaceholder + "\"}";
        this.unavailablePlaceholderIntArray = new ArrayList<Integer>(this.unavailableValuePlaceholderBytes.limit());
        this.unavailablePlaceholderLongArray = new ArrayList<Long>(this.unavailableValuePlaceholderBytes.limit());
        for (byte b : this.unavailableValuePlaceholderBytes.array()) {
            this.unavailablePlaceholderIntArray.add(Integer.valueOf(b));
            this.unavailablePlaceholderLongArray.add(Long.valueOf(b));
        }
        this.valueConverterProvider = beanRegistry.lookupByName(StandardBeanNames.VALUE_CONVERTER, ValueConverterProvider.class);
        this.jdbcConnection = beanRegistry.lookupByName(StandardBeanNames.JDBC_CONNECTION, JdbcConnection.class);
        this.schema = beanRegistry.lookupByName("Schema", RelationalDatabaseSchema.class);
    }

    private Object resolveKeyFieldValue(Struct key, Field field) {
        Struct value;
        if (field.schema() != null && "io.debezium.data.VariableScaleDecimal".equals(field.schema().name()) && (value = key.getStruct(field.name())) != null) {
            SpecialValueDecimal decimal = VariableScaleDecimal.toLogical(key.getStruct(field.name()));
            return decimal.getWrappedValue();
        }
        return key.get(field);
    }

    private List<String> getRequiredColumnSelections(TableId tableId, Struct after) {
        ArrayList<String> columnSelections = new ArrayList<String>();
        for (Field field : after.schema().fields()) {
            String fullyQualifiedName;
            Object value = after.get(field);
            if (this.reselectUnavailableValues && this.isUnavailableValueHolder(field, value)) {
                fullyQualifiedName = this.jdbcConnection.getQualifiedTableName(tableId) + ":" + field.name();
                if (!this.selector.test(fullyQualifiedName)) continue;
                LOGGER.debug("Adding column {} for table {} to re-select list due to unavailable value placeholder.", (Object)field.name(), (Object)tableId);
                columnSelections.add(field.name());
                continue;
            }
            if (!this.reselectNullValues || value != null || !this.selector.test(fullyQualifiedName = this.jdbcConnection.getQualifiedTableName(tableId) + ":" + field.name())) continue;
            LOGGER.debug("Adding empty column {} for table {} to re-select list.", (Object)field.name(), (Object)tableId);
            columnSelections.add(field.name());
        }
        return columnSelections;
    }

    private boolean isUnavailableValueHolder(Field field, Object value) {
        if (this.unavailableValuePlaceholder != null) {
            if (field.schema().type() == Schema.Type.ARRAY && value != null) {
                Collection values = (Collection)value;
                for (Object collectionValue : values) {
                    if (!this.isUnavailableValueHolder(field.schema().valueSchema(), collectionValue)) continue;
                    return true;
                }
                return this.isUnavailableArrayValueHolder(field.schema(), value);
            }
            return this.isUnavailableValueHolder(field.schema(), value);
        }
        return false;
    }

    private boolean isUnavailableValueHolder(Schema schema, Object value) {
        switch (schema.type()) {
            case BYTES: {
                if (value instanceof byte[]) {
                    byte[] valueArray = (byte[])value;
                    return ByteBuffers.equals(this.unavailableValuePlaceholderBytes, valueArray);
                }
                if (value instanceof ByteBuffer) {
                    ByteBuffer valueBuffer = (ByteBuffer)value;
                    return this.unavailableValuePlaceholderBytes.equals(valueBuffer);
                }
                return false;
            }
            case MAP: {
                return this.unavailableValuePlaceholderMap.equals(value);
            }
            case STRING: {
                boolean isJsonAndUnavailable = "io.debezium.data.Json".equals(schema.name()) && this.unavailableValuePlaceholderJson.equals(value);
                return this.unavailableValuePlaceholder.equals(value) || isJsonAndUnavailable;
            }
        }
        return false;
    }

    private boolean isUnavailableArrayValueHolder(Schema schema, Object value) {
        assert (schema.type() == Schema.Type.ARRAY);
        switch (schema.valueSchema().type()) {
            case INT32: {
                return this.unavailablePlaceholderIntArray.equals(value);
            }
            case INT64: {
                return this.unavailablePlaceholderLongArray.equals(value);
            }
        }
        return false;
    }

    private Object getConvertedValue(Column column, Field field, Object value) {
        ValueConverter converter = this.valueConverterProvider.converter(column, field);
        if (converter != null) {
            return converter.convert(value);
        }
        return value;
    }

    private TableId getTableIdFromSource(Struct source) {
        String databaseName = source.getString("db");
        if (Strings.isNullOrEmpty(databaseName)) {
            LOGGER.debug("Database name is not available, no re-selection possible.");
            return null;
        }
        String tableName = source.getString("table");
        if (Strings.isNullOrEmpty(tableName)) {
            LOGGER.debug("Table name is not available, no re-selection possible.");
            return null;
        }
        String schemaName = null;
        if (source.schema().field("schema") != null) {
            schemaName = source.getString("schema");
        }
        return this.jdbcConnection.createTableId(databaseName, schemaName, tableName);
    }

    public static enum ErrorHandlingMode implements EnumeratedValue
    {
        WARN("warn"),
        FAIL("fail");

        private final String value;

        private ErrorHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static ErrorHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (ErrorHandlingMode option : ErrorHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    private static class ReselectColumnsPredicateBuilder {
        private Predicate<String> reselectColumnInclusions;
        private Predicate<String> reselectColumnExclusions;

        private ReselectColumnsPredicateBuilder() {
        }

        public ReselectColumnsPredicateBuilder includeColumns(String columnNames) {
            this.reselectColumnInclusions = columnNames == null || columnNames.trim().isEmpty() ? null : Predicates.includes(columnNames, 2);
            return this;
        }

        public ReselectColumnsPredicateBuilder excludeColumns(String columnNames) {
            this.reselectColumnExclusions = columnNames == null || columnNames.trim().isEmpty() ? null : Predicates.excludes(columnNames, 2);
            return this;
        }

        public Predicate<String> build() {
            if (this.reselectColumnInclusions != null) {
                return this.reselectColumnInclusions;
            }
            if (this.reselectColumnExclusions != null) {
                return this.reselectColumnExclusions;
            }
            return x -> true;
        }
    }
}

