/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.notification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.pipeline.notification.channels.jmx.JmxNotificationChannel;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notification {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxNotificationChannel.class);
    public static final String ID_KEY = "id";
    public static final String TYPE = "type";
    public static final String AGGREGATE_TYPE = "aggregate_type";
    public static final String ADDITIONAL_DATA = "additional_data";
    public static final String TIMESTAMP = "timestamp";
    public static final ObjectMapper MAPPER = new ObjectMapper();
    @JsonIgnore
    private final String id;
    private final String aggregateType;
    private final String type;
    private final Map<String, String> additionalData;
    private final Long timestamp;

    @ConstructorProperties(value={"id", "aggregateType", "type", "additionalData", "timestamp"})
    public Notification(String id, String aggregateType, String type, Map<String, String> additionalData, Long timestamp) {
        this.id = id;
        this.aggregateType = aggregateType;
        this.type = type;
        this.additionalData = additionalData;
        this.timestamp = timestamp;
    }

    public String getId() {
        return this.id;
    }

    public String getAggregateType() {
        return this.aggregateType;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "{id='" + this.id + "', aggregateType='" + this.aggregateType + "', type='" + this.type + "', additionalData=" + String.valueOf(this.additionalData) + ", timestamp=" + this.timestamp + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.aggregateType, that.aggregateType) && Objects.equals(this.type, that.type) && Objects.equals(this.additionalData, that.additionalData) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.aggregateType, this.type, this.additionalData, this.timestamp);
    }

    public String toJson() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Error converting the notification object to json. Providing default toString value...", (Throwable)e);
            return this.toString();
        }
    }

    public static final class Builder {
        private String id;
        private String aggregateType;
        private String type;
        private Map<String, String> additionalData;
        private Long timestamp;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withAggregateType(String aggregateType) {
            this.aggregateType = aggregateType;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withAdditionalData(Map<String, String> additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public Builder withTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Notification build() {
            return new Notification(this.id, this.aggregateType, this.type, this.additionalData, this.timestamp);
        }
    }
}

