/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryMetrics;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.MemoryDatabaseHistory;
import java.util.Arrays;
import java.util.Collection;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractDatabaseHistoryTest
extends AbstractConnectorTest {
    private MemoryDatabaseHistory databaseHistory;

    @Before
    public void beforeEach() {
        this.databaseHistory = new MemoryDatabaseHistory();
    }

    @After
    public void afterEach() {
        if (this.databaseHistory != null) {
            this.databaseHistory.stop();
        }
    }

    @Test
    @FixFor(value={"DBZ-4451"})
    public void shouldRecoverRenamedTableWithOnlyTheRenamedEntry() throws Exception {
        this.record(this.getRenameCreateHistoryRecord(), this.getRenameAlterHistoryRecord());
        Tables tables = this.recoverHistory();
        Assertions.assertThat((int)tables.size()).isEqualTo(1);
        Assertions.assertThat((Collection)tables.tableIds()).containsOnly(new Object[]{this.getRenameTableId()});
    }

    protected abstract HistoryRecord getRenameCreateHistoryRecord();

    protected abstract HistoryRecord getRenameAlterHistoryRecord();

    protected abstract TableId getRenameTableId();

    protected abstract Offsets<Partition, OffsetContext> getOffsets();

    protected abstract DdlParser getDdlParser();

    protected Configuration getHistoryConfiguration() {
        return ((Configuration.Builder)Configuration.create().with(DatabaseHistory.NAME, "my-db-history")).build();
    }

    protected void record(HistoryRecord ... records) throws Exception {
        Arrays.stream(records).forEach(arg_0 -> ((MemoryDatabaseHistory)this.databaseHistory).storeRecord(arg_0));
    }

    protected Tables recoverHistory() {
        this.databaseHistory.configure(this.getHistoryConfiguration(), null, DatabaseHistoryMetrics.NOOP, true);
        this.databaseHistory.start();
        this.databaseHistory.initializeStorage();
        Tables tables = new Tables();
        this.databaseHistory.recover(this.getOffsets(), tables, this.getDdlParser());
        return tables;
    }
}

