/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.DebeziumException;
import io.debezium.embedded.async.AsyncEmbeddedEngine;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.source.EngineSourceTask;
import io.debezium.pipeline.signal.SignalRecord;
import io.debezium.pipeline.signal.channels.process.InProcessSignalChannel;
import java.util.List;
import java.util.Optional;

public class AsyncEngineSignaler
implements DebeziumEngine.Signaler<SignalRecord> {
    private AsyncEmbeddedEngine<?> engine;
    private List<InProcessSignalChannel> channels;

    public <E extends DebeziumEngine<?>> void init(E engine) {
        if (!(engine instanceof AsyncEmbeddedEngine)) {
            throw new DebeziumException("AsyncEngineSignaler can only be used with AsyncEmbeddedEngine");
        }
        this.engine = (AsyncEmbeddedEngine)engine;
    }

    public void signal(SignalRecord signal) {
        if (this.channels == null) {
            this.channels = this.engine.tasks().stream().map(EngineSourceTask::debeziumConnectTask).flatMap(Optional::stream).map(task -> task.getSignalChannel(InProcessSignalChannel.class)).flatMap(Optional::stream).toList();
        }
        this.channels.forEach(channel -> channel.signal(signal));
    }
}

