/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.kafka.connect.source.SourceConnector;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMetricsTest<T extends SourceConnector>
extends AbstractConnectorTest {
    protected abstract Class<T> getConnectorClass();

    protected abstract String connector();

    protected abstract String server();

    protected abstract Configuration.Builder config();

    protected abstract Configuration.Builder noSnapshot(Configuration.Builder var1);

    protected abstract void executeInsertStatements() throws Exception;

    protected abstract String tableName();

    protected abstract long expectedEvents();

    protected abstract boolean snapshotCompleted();

    protected String task() {
        return null;
    }

    protected String database() {
        return null;
    }

    protected void start() {
        Configuration config = this.config().build();
        this.start(this.getConnectorClass(), config, this.loggingCompletion(), null);
    }

    protected void start(Function<Configuration.Builder, Configuration.Builder> custConfig) {
        Configuration config = custConfig.apply(this.config()).build();
        this.start(this.getConnectorClass(), config, this.loggingCompletion(), null);
    }

    @Test
    public void testLifecycle() throws Exception {
        this.start();
        this.assertConnectorIsRunning();
        AbstractMetricsTest.waitForSnapshotToBeCompleted(this.connector(), this.server(), this.task(), this.database());
        AbstractMetricsTest.waitForStreamingRunning(this.connector(), this.server(), AbstractMetricsTest.getStreamingNamespace(), this.task());
        this.stopConnector();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getMBeanInfo(this.getSnapshotMetricsObjectName());
            Assert.fail((String)"Expected Snapshot Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        try {
            mBeanServer.getMBeanInfo(this.getStreamingMetricsObjectName());
            Assert.fail((String)"Expected Streaming Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSnapshotOnlyMetrics() throws Exception {
        this.executeInsertStatements();
        this.start();
        this.assertSnapshotMetrics();
    }

    @Test
    public void testSnapshotAndStreamingMetrics() throws Exception {
        this.executeInsertStatements();
        this.start();
        this.assertConnectorIsRunning();
        this.assertSnapshotMetrics();
        this.consumeRecords(2);
        this.assertStreamingMetrics(false, this.expectedEvents());
    }

    @Test
    @FixFor(value={"DBZ-6603"})
    public void testSnapshotAndStreamingWithCustomMetrics() throws Exception {
        this.executeInsertStatements();
        Map<String, String> customMetricTags = Map.of("env", "test", "bu", "bigdata");
        this.start(x -> (Configuration.Builder)x.with(CommonConnectorConfig.CUSTOM_METRIC_TAGS, "env=test,bu=bigdata"));
        this.assertSnapshotWithCustomMetrics(customMetricTags);
        this.consumeRecords(2);
        this.assertStreamingWithCustomMetrics(customMetricTags, this.expectedEvents());
    }

    @Test
    public void testStreamingOnlyMetrics() throws Exception {
        this.start(this::noSnapshot);
        AbstractMetricsTest.waitForStreamingRunning(this.connector(), this.server(), AbstractMetricsTest.getStreamingNamespace(), this.task());
        this.assertSnapshotNotExecutedMetrics();
        this.assertStreamingMetrics(false, this.expectedEvents());
    }

    @Test
    public void testAdvancedStreamingMetrics() throws Exception {
        this.start(x -> (Configuration.Builder)this.noSnapshot((Configuration.Builder)x).with(CommonConnectorConfig.ADVANCED_METRICS_ENABLE, (Object)Boolean.TRUE));
        AbstractMetricsTest.waitForStreamingRunning(this.connector(), this.server(), AbstractMetricsTest.getStreamingNamespace(), this.task());
        this.assertSnapshotNotExecutedMetrics();
        this.assertStreamingMetrics(true, this.expectedEvents());
    }

    @Test
    public void testPauseAndResumeAdvancedStreamingMetrics() throws Exception {
        this.start(x -> (Configuration.Builder)this.noSnapshot((Configuration.Builder)x).with(CommonConnectorConfig.ADVANCED_METRICS_ENABLE, (Object)Boolean.TRUE));
        AbstractMetricsTest.waitForStreamingRunning(this.connector(), this.server(), AbstractMetricsTest.getStreamingNamespace(), this.task());
        this.assertSnapshotNotExecutedMetrics();
        this.assertStreamingMetrics(true, this.expectedEvents());
        this.invokeOperation(this.getMultiplePartitionStreamingMetricsObjectName(), "pause");
        this.insertRecords();
        this.assertAdvancedMetrics(2L);
        this.invokeOperation(this.getMultiplePartitionStreamingMetricsObjectName(), "resume");
        this.insertRecords();
        this.consumeRecords(4);
        this.assertAdvancedMetrics(4L);
    }

    private void insertRecords() throws Exception {
        this.executeInsertStatements();
        this.waitForAvailableRecords(30L, TimeUnit.SECONDS);
        Thread.sleep(Duration.ofSeconds(2L).toMillis());
    }

    protected void assertSnapshotMetrics() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        AbstractMetricsTest.waitForSnapshotToBeCompleted(this.connector(), this.server(), this.task(), this.database());
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "TotalTableCount")).isEqualTo((Object)1);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "CapturedTables")).isEqualTo((Object)new String[]{this.tableName()});
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "TotalNumberOfEventsSeen")).isEqualTo((Object)2L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "RemainingTableCount")).isEqualTo((Object)0);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotRunning")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotAborted")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted")).isEqualTo((Object)true);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotPaused")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotPausedDurationInSeconds")).isEqualTo((Object)0L);
    }

    protected void assertSnapshotWithCustomMetrics(Map<String, String> customMetricTags) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = AbstractMetricsTest.getSnapshotMetricsObjectName(this.connector(), this.server(), this.task(), this.database(), customMetricTags);
        AbstractMetricsTest.waitForSnapshotWithCustomMetricsToBeCompleted(this.connector(), this.server(), this.task(), this.database(), customMetricTags);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "TotalTableCount")).isEqualTo((Object)1);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "CapturedTables")).isEqualTo((Object)new String[]{this.tableName()});
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "TotalNumberOfEventsSeen")).isEqualTo((Object)2L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "RemainingTableCount")).isEqualTo((Object)0);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotRunning")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotAborted")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotCompleted")).isEqualTo((Object)true);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotPaused")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotPausedDurationInSeconds")).isEqualTo((Object)0L);
    }

    private void assertSnapshotNotExecutedMetrics() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Awaitility.await((String)"Waiting for snapshot metrics to appear").atMost((long)AbstractMetricsTest.waitTimeForRecords(), TimeUnit.SECONDS).until(() -> {
            try {
                mBeanServer.getObjectInstance(this.getSnapshotMetricsObjectName());
                return true;
            }
            catch (InstanceNotFoundException e) {
                return false;
            }
        });
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "TotalNumberOfEventsSeen")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted")).isEqualTo((Object)this.snapshotCompleted());
    }

    protected void assertStreamingMetrics(boolean checkAdvancedMetrics, long expectedEvents) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        AbstractMetricsTest.waitForStreamingRunning(this.connector(), this.server(), AbstractMetricsTest.getStreamingNamespace(), this.task());
        this.executeInsertStatements();
        this.consumeRecordsByTopic((int)expectedEvents);
        Thread.sleep(Duration.ofSeconds(2L).toMillis());
        Testing.print((Object)"****ASSERTIONS****");
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "Connected")).isEqualTo((Object)true);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getMultiplePartitionStreamingMetricsObjectName(), "TotalNumberOfCreateEventsSeen")).isEqualTo((Object)expectedEvents);
        if (checkAdvancedMetrics) {
            this.assertAdvancedMetrics(2L);
        }
    }

    public void assertAdvancedMetrics(long expectedInsert) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        TabularDataSupport numberOfCreateEventsSeen = (TabularDataSupport)mBeanServer.getAttribute(AbstractMetricsTest.getStreamingMetricsObjectName(this.connector(), this.server(), AbstractMetricsTest.getStreamingNamespace(), this.task(), this.database()), "NumberOfCreateEventsSeen");
        String values = numberOfCreateEventsSeen.values().stream().limit(1L).toList().get(0).toString();
        Assertions.assertThat((String)values).isEqualTo((Object)("javax.management.openmbean.CompositeDataSupport(compositeType=javax.management.openmbean.CompositeType(name=java.util.Map<java.lang.String, java.lang.Long>,items=((itemName=key,itemType=javax.management.openmbean.SimpleType(name=java.lang.String)),(itemName=value,itemType=javax.management.openmbean.SimpleType(name=java.lang.Long)))),contents={key=" + this.tableName() + ", value=" + expectedInsert + "})"));
    }

    private void invokeOperation(ObjectName objectName, String operation) throws ReflectionException, InstanceNotFoundException, MBeanException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.invoke(objectName, operation, new Object[0], new String[0]);
    }

    protected void assertStreamingWithCustomMetrics(Map<String, String> customMetricTags, long expectedEvents) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        AbstractMetricsTest.waitForStreamingWithCustomMetricsToStart(this.connector(), this.server(), this.task(), this.database(), customMetricTags);
        this.executeInsertStatements();
        this.waitForAvailableRecords(30L, TimeUnit.SECONDS);
        this.consumeRecords((int)expectedEvents);
        Thread.sleep(Duration.ofSeconds(2L).toMillis());
        Testing.print((Object)"****ASSERTIONS****");
        Assertions.assertThat((Object)mBeanServer.getAttribute(AbstractMetricsTest.getStreamingMetricsObjectName(this.connector(), this.server(), this.task(), null, customMetricTags), "Connected")).isEqualTo((Object)true);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getMultiplePartitionStreamingMetricsObjectNameCustomTags(customMetricTags), "TotalNumberOfCreateEventsSeen")).isEqualTo((Object)expectedEvents);
    }

    protected ObjectName getSnapshotMetricsObjectName() throws MalformedObjectNameException {
        return AbstractMetricsTest.getSnapshotMetricsObjectName(this.connector(), this.server());
    }

    protected ObjectName getStreamingMetricsObjectName() throws MalformedObjectNameException {
        return AbstractMetricsTest.getStreamingMetricsObjectName(this.connector(), this.server());
    }

    protected ObjectName getMultiplePartitionStreamingMetricsObjectName() throws MalformedObjectNameException {
        return AbstractMetricsTest.getStreamingMetricsObjectName(this.connector(), this.server());
    }

    protected ObjectName getMultiplePartitionStreamingMetricsObjectNameCustomTags(Map<String, String> customTags) throws MalformedObjectNameException {
        return AbstractMetricsTest.getStreamingMetricsObjectName(this.connector(), this.server(), customTags);
    }
}

