/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ValidationFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ValidationFluentImpl;

public class ValidationBuilder
extends ValidationFluentImpl<ValidationBuilder>
implements VisitableBuilder<Validation, ValidationBuilder> {
    ValidationFluent<?> fluent;
    Boolean validationEnabled;

    public ValidationBuilder() {
        this(false);
    }

    public ValidationBuilder(Boolean validationEnabled) {
        this(new Validation(), validationEnabled);
    }

    public ValidationBuilder(ValidationFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ValidationBuilder(ValidationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Validation(), validationEnabled);
    }

    public ValidationBuilder(ValidationFluent<?> fluent, Validation instance) {
        this(fluent, instance, false);
    }

    public ValidationBuilder(ValidationFluent<?> fluent, Validation instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExpression(instance.getExpression());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ValidationBuilder(Validation instance) {
        this(instance, (Boolean)false);
    }

    public ValidationBuilder(Validation instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExpression(instance.getExpression());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public Validation build() {
        Validation buildable = new Validation(this.fluent.getExpression(), this.fluent.getMessage(), this.fluent.getReason());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

