/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.zjsonpatch.JsonDiff;
import java.util.Optional;

public class PatchUtils {
    private PatchUtils() {
    }

    public static String withoutRuntimeState(Object object, Format format, boolean omitStatus) {
        ObjectMapper mapper = format == Format.JSON ? Serialization.jsonMapper() : Serialization.yamlMapper();
        try {
            return mapper.writeValueAsString((Object)PatchUtils.withoutRuntimeState(object, omitStatus));
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    static JsonNode withoutRuntimeState(Object object, boolean omitStatus) {
        ObjectNode raw = (ObjectNode)SingletonHolder.patchMapper.convertValue(object, ObjectNode.class);
        Optional.ofNullable(raw.get("metadata")).filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).ifPresent(m -> {
            m.remove("creationTimestamp");
            m.remove("deletionTimestamp");
            m.remove("generation");
            m.remove("selfLink");
            m.remove("uid");
        });
        if (omitStatus) {
            raw.remove("status");
        }
        return raw;
    }

    public static String jsonDiff(Object current, Object updated, boolean omitStatus) {
        try {
            return Serialization.jsonMapper().writeValueAsString((Object)JsonDiff.asJson((JsonNode)PatchUtils.withoutRuntimeState(current, omitStatus), (JsonNode)PatchUtils.withoutRuntimeState(updated, omitStatus)));
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private static class SingletonHolder {
        public static final ObjectMapper patchMapper = Serialization.jsonMapper().copy();

        private SingletonHolder() {
        }

        static {
            patchMapper.setConfig(patchMapper.getSerializationConfig().without(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS));
        }
    }

    public static enum Format {
        YAML,
        JSON;

    }
}

