/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.AbstractConfigurationService;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.InformerStoppedHandler;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceConfigurationResolver;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResourceFactory;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflowFactory;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusConfigurationService
extends AbstractConfigurationService
implements DependentResourceFactory<QuarkusControllerConfiguration<?>>,
ManagedWorkflowFactory<QuarkusControllerConfiguration<?>> {
    private static final Logger log = LoggerFactory.getLogger(QuarkusConfigurationService.class);
    private final KubernetesClient client;
    private final CRDGenerationInfo crdInfo;
    private final int concurrentReconciliationThreads;
    private final int terminationTimeout;
    private final Map<String, String> reconcilerClassToName;
    private final Metrics metrics;
    private final boolean startOperator;
    private final LeaderElectionConfiguration leaderElectionConfiguration;
    private final InformerStoppedHandler informerStoppedHandler;
    private final boolean closeClientOnStop;
    private final boolean stopOnInformerErrorDuringStartup;
    private final int concurrentWorkflowExecutorThreads;
    private final Duration cacheSyncTimeout;
    private final Map<String, DependentResource> knownDependents = new ConcurrentHashMap<String, DependentResource>();

    public QuarkusConfigurationService(Version version, Collection<QuarkusControllerConfiguration> configurations, KubernetesClient client, CRDGenerationInfo crdInfo, int maxThreads, int maxWorflowThreads, int timeout, Duration cacheSyncTimeout, Metrics metrics, boolean startOperator, final ObjectMapper mapper, LeaderElectionConfiguration leaderElectionConfiguration, InformerStoppedHandler informerStoppedHandler, boolean closeClientOnStop, boolean stopOnInformerErrorDuringStartup) {
        super(version);
        this.closeClientOnStop = closeClientOnStop;
        this.stopOnInformerErrorDuringStartup = stopOnInformerErrorDuringStartup;
        Cloner cloner = new Cloner(){

            public <R extends HasMetadata> R clone(R r) {
                try {
                    return (R)((HasMetadata)mapper.readValue(mapper.writeValueAsString(r), r.getClass()));
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        this.init(cloner, mapper);
        this.startOperator = startOperator;
        this.client = client;
        this.metrics = metrics;
        if (configurations != null && !configurations.isEmpty()) {
            int size = configurations.size();
            this.reconcilerClassToName = new HashMap<String, String>(size);
            configurations.forEach(c -> {
                String name = c.getName();
                this.reconcilerClassToName.put(c.getAssociatedReconcilerClassName(), name);
                this.register((ControllerConfiguration)c);
            });
        } else {
            this.reconcilerClassToName = Collections.emptyMap();
        }
        this.crdInfo = crdInfo;
        this.concurrentReconciliationThreads = maxThreads;
        this.concurrentWorkflowExecutorThreads = maxWorflowThreads;
        this.terminationTimeout = timeout;
        this.cacheSyncTimeout = cacheSyncTimeout;
        this.informerStoppedHandler = informerStoppedHandler;
        this.leaderElectionConfiguration = leaderElectionConfiguration;
    }

    public Config getClientConfiguration() {
        return this.client.getConfiguration();
    }

    public <R extends HasMetadata> QuarkusControllerConfiguration<R> getConfigurationFor(Reconciler<R> reconciler) {
        Reconciler<R> unwrapped = QuarkusConfigurationService.unwrap(reconciler);
        QuarkusControllerConfiguration configuration = (QuarkusControllerConfiguration)super.getConfigurationFor(unwrapped);
        configuration.initAnnotationConfigurables(unwrapped);
        return configuration;
    }

    public boolean checkCRDAndValidateLocalModel() {
        return this.crdInfo.isValidateCRDs();
    }

    private static <R extends HasMetadata> Reconciler<R> unwrap(Reconciler<R> reconciler) {
        return (Reconciler)ClientProxy.unwrap(reconciler);
    }

    protected String keyFor(Reconciler controller) {
        String controllerName;
        String controllerClass = controller.getClass().getName();
        int i = controllerClass.indexOf(95);
        if (i > 0) {
            controllerClass = controllerClass.substring(0, i);
        }
        if ((controllerName = this.reconcilerClassToName.get(controllerClass)) == null) {
            throw new IllegalArgumentException("Unknown controller " + controllerClass);
        }
        return controllerName;
    }

    public int concurrentReconciliationThreads() {
        return this.concurrentReconciliationThreads;
    }

    public int getTerminationTimeoutSeconds() {
        return this.terminationTimeout;
    }

    public CRDGenerationInfo getCRDGenerationInfo() {
        return this.crdInfo;
    }

    protected void logMissingReconcilerWarning(String reconcilerKey, String reconcilersNameMessage) {
        log.warn("Cannot find configuration for '{}' reconciler. {}", (Object)reconcilerKey, (Object)reconcilersNameMessage);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    KubernetesClient getClient() {
        return this.client;
    }

    boolean shouldStartOperator() {
        return this.startOperator;
    }

    public Stream<ControllerConfiguration> controllerConfigurations() {
        return super.controllerConfigurations();
    }

    public Optional<LeaderElectionConfiguration> getLeaderElectionConfiguration() {
        return Optional.ofNullable(this.leaderElectionConfiguration);
    }

    public Optional<InformerStoppedHandler> getInformerStoppedHandler() {
        return Optional.ofNullable(this.informerStoppedHandler);
    }

    public int concurrentWorkflowExecutorThreads() {
        return this.concurrentWorkflowExecutorThreads;
    }

    public boolean closeClientOnStop() {
        return this.closeClientOnStop;
    }

    public boolean stopOnInformerErrorDuringStartup() {
        return this.stopOnInformerErrorDuringStartup;
    }

    public Duration cacheSyncTimeout() {
        return this.cacheSyncTimeout;
    }

    public DependentResourceFactory<QuarkusControllerConfiguration<?>> dependentResourceFactory() {
        return this;
    }

    public ManagedWorkflowFactory<QuarkusControllerConfiguration<?>> getWorkflowFactory() {
        return this;
    }

    public ManagedWorkflow<?> workflowFor(QuarkusControllerConfiguration<?> controllerConfiguration) {
        return controllerConfiguration.getWorkflow();
    }

    public DependentResource createFrom(DependentResourceSpec spec, QuarkusControllerConfiguration configuration) {
        String dependentKey = QuarkusConfigurationService.getDependentKey(configuration, spec);
        DependentResource dependentResource = this.knownDependents.get(dependentKey);
        if (dependentResource == null) {
            Class dependentResourceClass = spec.getDependentResourceClass();
            DependentResource dependent = (DependentResource)Arc.container().instance(dependentResourceClass, new Annotation[0]).get();
            if (dependent == null) {
                throw new IllegalStateException("Couldn't find bean associated with DependentResource " + dependentResourceClass.getName());
            }
            dependentResource = (DependentResource)ClientProxy.unwrap((Object)dependent);
            DependentResourceConfigurationResolver.configure((DependentResource)dependentResource, (DependentResourceSpec)spec, (ControllerConfiguration)configuration);
            this.knownDependents.put(dependentKey, dependentResource);
        }
        return dependentResource;
    }

    private static String getDependentKey(QuarkusControllerConfiguration configuration, DependentResourceSpec spec) {
        return QuarkusConfigurationService.getDependentKeyFromNames(configuration.getName(), spec.getName());
    }

    private static String getDependentKeyFromNames(String controllerName, String dependentName) {
        return controllerName + "#" + dependentName;
    }

    public DependentResourceSpecMetadata getDependentByName(String controllerName, String dependentName) {
        return this.controllerConfigurations().filter(cc -> controllerName.equals(cc.getName())).findFirst().flatMap(cc -> cc.getDependentResources().stream().filter(drs -> dependentName.equals(((DependentResourceSpec)drs).getName())).findFirst()).orElse(null);
    }

    public ManagedWorkflow workflowByName(String name) {
        return ((QuarkusControllerConfiguration)this.getFor(name)).getWorkflow();
    }
}

