/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime.devconsole;

import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.processing.Controller;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.devconsole.ControllerInfo;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllersSupplier
implements Supplier<Collection<ControllerInfo>> {
    private static final Logger log = LoggerFactory.getLogger(ControllersSupplier.class);

    @Override
    public Collection<ControllerInfo> get() {
        Collection collection;
        block8: {
            InstanceHandle operatorHandle = Arc.container().instance(Operator.class, new Annotation[0]);
            try {
                collection = ((Operator)operatorHandle.get()).getRegisteredControllers().stream().map(rc -> new ControllerInfo((Controller)rc)).collect(Collectors.toList());
                if (operatorHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (operatorHandle != null) {
                        try {
                            operatorHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Couldn't retrieve controllers information because " + QuarkusConfigurationService.class.getSimpleName() + " is not available", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            operatorHandle.close();
        }
        return collection;
    }

    public int count() {
        int n;
        block8: {
            InstanceHandle operatorHandle = Arc.container().instance(Operator.class, new Annotation[0]);
            try {
                n = ((Operator)operatorHandle.get()).getRegisteredControllersNumber();
                if (operatorHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (operatorHandle != null) {
                        try {
                            operatorHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Couldn't retrieve controllers information because " + QuarkusConfigurationService.class.getSimpleName() + " is not available", (Throwable)e);
                    return 0;
                }
            }
            operatorHandle.close();
        }
        return n;
    }
}

