/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.impl.TypeCachePollutionUtils;
import jakarta.enterprise.inject.CreationException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;

public final class Reflections {
    private static final ComputingCache<FieldKey, Field> FIELDS_CACHE = new ComputingCache<FieldKey, Field>(new Function<FieldKey, Field>(){

        @Override
        public Field apply(FieldKey key) {
            return Reflections.findFieldInternal(key.clazz, key.fieldName);
        }
    });
    private static final ComputingCache<MethodKey, Method> METHODS_CACHE = new ComputingCache<MethodKey, Method>(new Function<MethodKey, Method>(){

        @Override
        public Method apply(MethodKey key) {
            return Reflections.findMethodInternal(key.clazz, key.methodName, key.parameterTypes);
        }
    });

    static void clearCaches() {
        FIELDS_CACHE.clear();
        METHODS_CACHE.clear();
    }

    private Reflections() {
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        return FIELDS_CACHE.getValue(new FieldKey(clazz, fieldName));
    }

    private static Field findFieldInternal(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return Reflections.findFieldInternal(clazz.getSuperclass(), fieldName);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return METHODS_CACHE.getValue(new MethodKey(clazz, methodName, parameterTypes));
    }

    private static Method findMethodInternal(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        ArrayDeque interfaces = new ArrayDeque();
        for (Class<?> theClass = clazz; theClass != null; theClass = theClass.getSuperclass()) {
            try {
                return theClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                interfaces.addAll(Arrays.asList(theClass.getInterfaces()));
                continue;
            }
        }
        HashSet seen = new HashSet(interfaces);
        while (!interfaces.isEmpty()) {
            Class iface = (Class)interfaces.pop();
            try {
                return iface.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class<?> extra : iface.getInterfaces()) {
                    if (!seen.add(extra)) continue;
                    interfaces.add(extra);
                }
            }
        }
        throw new IllegalArgumentException("Cannot find method " + methodName + Arrays.asList(parameterTypes) + " on " + clazz);
    }

    public static Constructor<?> findConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Object newInstance(Class<?> clazz, Class<?>[] parameterTypes, Object[] args) {
        Constructor<?> constructor = Reflections.findConstructor(clazz, parameterTypes);
        if (constructor != null) {
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            try {
                return constructor.newInstance(args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new CreationException(cause);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException("Cannot invoke constructor: " + clazz.getName(), e);
            }
        }
        throw new RuntimeException("No " + clazz.getName() + "constructor found for params: " + Arrays.toString(parameterTypes));
    }

    public static Object readField(Class<?> clazz, String name, Object instance) {
        try {
            Field field = clazz.getDeclaredField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Cannot read field value: " + clazz.getName() + "#" + name, e);
        }
    }

    public static void writeField(Class<?> clazz, String name, Object instance, Object value) {
        try {
            Field field = clazz.getDeclaredField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Cannot set field value: " + clazz.getName() + "#" + name, e);
        }
    }

    public static Object invokeMethod(Class<?> clazz, String name, Class<?>[] paramTypes, Object instance, Object[] args) {
        try {
            Method method = clazz.getDeclaredMethod(name, paramTypes);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Cannot invoke method: " + clazz.getName() + "#" + name + " on " + instance, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Cannot invoke method: " + clazz.getName() + "#" + name + " on " + instance, e);
        }
    }

    static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static <T> Class<T> getRawType(Type type) {
        GenericArrayType genericArrayType;
        Class<T> rawType;
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (TypeCachePollutionUtils.isParameterizedType(type) && (parameterizedType = TypeCachePollutionUtils.asParameterizedType(type)).getRawType() instanceof Class) {
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            Type[] bounds = variable.getBounds();
            return Reflections.getBound(bounds);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return Reflections.getBound(wildcard.getUpperBounds());
        }
        if (type instanceof GenericArrayType && (rawType = Reflections.getRawType((genericArrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        return null;
    }

    private static <T> Class<T> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return Reflections.getRawType(bounds[0]);
    }

    static final class FieldKey {
        final Class<?> clazz;
        final String fieldName;
        final int hashCode;

        public FieldKey(Class<?> clazz, String fieldName) {
            this.clazz = clazz;
            this.fieldName = fieldName;
            int prime = 31;
            int result = 1;
            result = 31 * result + (clazz == null ? 0 : clazz.hashCode());
            this.hashCode = result = 31 * result + (fieldName == null ? 0 : fieldName.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldKey other = (FieldKey)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.fieldName, other.fieldName);
        }
    }

    static final class MethodKey {
        final Class<?> clazz;
        final String methodName;
        final Class<?>[] parameterTypes;
        final int hashCode;

        public MethodKey(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(parameterTypes);
            result = 31 * result + (clazz == null ? 0 : clazz.hashCode());
            this.hashCode = result = 31 * result + (methodName == null ? 0 : methodName.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.methodName, other.methodName) && Arrays.equals(this.parameterTypes, other.parameterTypes);
        }
    }
}

