/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.javaoperatorsdk.operator.OperatorException;
import java.util.Arrays;

public class CustomResourceUtils {
    private CustomResourceUtils() {
    }

    public static void assertCustomResource(Class<?> resClass, CustomResourceDefinition crd) {
        boolean namespaced = Arrays.asList(resClass.getInterfaces()).contains(Namespaced.class);
        if (!namespaced && Namespaced.class.getSimpleName().equals(crd.getSpec().getScope())) {
            throw new OperatorException("Custom resource '" + resClass.getName() + "' must implement '" + Namespaced.class.getName() + "' since CRD '" + crd.getMetadata().getName() + "' is scoped as 'Namespaced'");
        }
        if (namespaced && Cluster.class.getSimpleName().equals(crd.getSpec().getScope())) {
            throw new OperatorException("Custom resource '" + resClass.getName() + "' must not implement '" + Namespaced.class.getName() + "' since CRD '" + crd.getMetadata().getName() + "' is scoped as 'Cluster'");
        }
    }
}

