/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewSpecBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.javaoperatorsdk.operator.ControllerManager;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionManager {
    private static final Logger log = LoggerFactory.getLogger(LeaderElectionManager.class);
    public static final String NO_PERMISSION_TO_LEASE_RESOURCE_MESSAGE = "No permission to lease resource.";
    private LeaderElector leaderElector = null;
    private final ControllerManager controllerManager;
    private String identity;
    private CompletableFuture<?> leaderElectionFuture;
    private KubernetesClient client;
    private String leaseName;
    private String leaseNamespace;

    public LeaderElectionManager(ControllerManager controllerManager) {
        this.controllerManager = controllerManager;
    }

    public void init(LeaderElectionConfiguration config, KubernetesClient client) {
        this.client = client;
        this.identity = this.identity(config);
        this.leaseName = config.getLeaseName();
        this.leaseNamespace = config.getLeaseNamespace().orElseGet(() -> ConfigurationServiceProvider.instance().getClientConfiguration().getNamespace());
        if (this.leaseNamespace == null) {
            String message = "Lease namespace is not set and cannot be inferred. Leader election cannot continue.";
            log.error("Lease namespace is not set and cannot be inferred. Leader election cannot continue.");
            throw new IllegalArgumentException("Lease namespace is not set and cannot be inferred. Leader election cannot continue.");
        }
        LeaseLock lock = new LeaseLock(this.leaseNamespace, this.leaseName, this.identity);
        this.leaderElector = new LeaderElectorBuilder(client, (Executor)ExecutorServiceManager.instance().executorService()).withConfig(new LeaderElectionConfig((Lock)lock, config.getLeaseDuration(), config.getRenewDeadline(), config.getRetryPeriod(), this.leaderCallbacks(), true, config.getLeaseName())).build();
    }

    public boolean isLeaderElectionEnabled() {
        return this.leaderElector != null;
    }

    private LeaderCallbacks leaderCallbacks() {
        return new LeaderCallbacks(this::startLeading, this::stopLeading, leader -> log.info("New leader with identity: {}", leader));
    }

    private void startLeading() {
        this.controllerManager.startEventProcessing();
    }

    private void stopLeading() {
        log.info("Stopped leading for identity: {}. Exiting.", (Object)this.identity);
        System.exit(1);
    }

    private String identity(LeaderElectionConfiguration config) {
        String id = config.getIdentity().orElseGet(() -> System.getenv("HOSTNAME"));
        if (id == null || id.isBlank()) {
            id = UUID.randomUUID().toString();
        }
        return id;
    }

    public void start() {
        if (this.isLeaderElectionEnabled()) {
            this.checkLeaseAccess();
            this.leaderElectionFuture = this.leaderElector.start();
        }
    }

    public void stop() {
        if (this.leaderElectionFuture != null) {
            this.leaderElectionFuture.cancel(false);
        }
    }

    private void checkLeaseAccess() {
        List<String> verbs = Arrays.asList("create", "update", "get");
        SelfSubjectRulesReview review = new SelfSubjectRulesReview();
        review.setSpec(((SelfSubjectRulesReviewSpecBuilder)new SelfSubjectRulesReviewSpecBuilder().withNamespace(this.leaseNamespace)).build());
        SelfSubjectRulesReview reviewResult = (SelfSubjectRulesReview)this.client.resource((HasMetadata)review).create();
        log.debug("SelfSubjectRulesReview result: {}", (Object)reviewResult);
        Optional<ResourceRule> foundRule = reviewResult.getStatus().getResourceRules().stream().filter(rule -> rule.getApiGroups().contains("coordination.k8s.io") && rule.getResources().contains("leases") && rule.getVerbs().containsAll(verbs) || rule.getVerbs().contains("*")).findAny();
        if (foundRule.isEmpty()) {
            throw new OperatorException("No permission to lease resource. in namespace: " + this.leaseNamespace);
        }
    }
}

