/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.javaoperatorsdk.operator.ControllerManager;
import io.javaoperatorsdk.operator.LeaderElectionManager;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.RegisteredController;
import io.javaoperatorsdk.operator.RuntimeInfo;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceOverrider;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.LifecycleAware;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operator
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(Operator.class);
    private static final int DEFAULT_MAX_CONCURRENT_REQUEST = 512;
    private final KubernetesClient kubernetesClient;
    private final ControllerManager controllerManager = new ControllerManager();
    private final LeaderElectionManager leaderElectionManager = new LeaderElectionManager(this.controllerManager);
    private volatile boolean started = false;

    public Operator() {
        this((KubernetesClient)null);
    }

    public Operator(KubernetesClient kubernetesClient) {
        this(kubernetesClient, ConfigurationServiceProvider.instance());
    }

    @Deprecated(forRemoval=true)
    public Operator(ConfigurationService configurationService) {
        this(null, configurationService);
    }

    public Operator(Consumer<ConfigurationServiceOverrider> overrider) {
        this(null, overrider);
    }

    public Operator(KubernetesClient client, Consumer<ConfigurationServiceOverrider> overrider) {
        this(client, ConfigurationServiceProvider.overrideCurrent(overrider));
    }

    public Operator(KubernetesClient kubernetesClient, ConfigurationService configurationService) {
        this.kubernetesClient = kubernetesClient != null ? kubernetesClient : new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequests(512)).build()).build();
        ConfigurationServiceProvider.set(configurationService);
        configurationService.getLeaderElectionConfiguration().ifPresent(c -> this.leaderElectionManager.init((LeaderElectionConfiguration)c, this.kubernetesClient));
    }

    @Deprecated(forRemoval=true)
    public void installShutdownHook() {
        this.installShutdownHook(Duration.ofSeconds(ConfigurationServiceProvider.instance().getTerminationTimeoutSeconds()));
    }

    public void installShutdownHook(Duration gracefulShutdownTimeout) {
        if (!this.leaderElectionManager.isLeaderElectionEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop(gracefulShutdownTimeout)));
        } else {
            log.warn("Leader election is on, shutdown hook will not be installed.");
        }
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    @Override
    public synchronized void start() {
        try {
            if (this.started) {
                return;
            }
            ExecutorServiceManager.init();
            this.controllerManager.shouldStart();
            Version version = ConfigurationServiceProvider.instance().getVersion();
            log.info("Operator SDK {} (commit: {}) built on {} starting...", new Object[]{version.getSdkVersion(), version.getCommit(), version.getBuiltTime()});
            String clientVersion = io.fabric8.kubernetes.client.Version.clientVersion();
            log.info("Client version: {}", (Object)clientVersion);
            this.controllerManager.start(!this.leaderElectionManager.isLeaderElectionEnabled());
            this.leaderElectionManager.start();
            this.started = true;
        }
        catch (Exception e) {
            this.stop();
            throw new OperatorException("Error starting operator", e);
        }
    }

    public void stop(Duration gracefulShutdownTimeout) throws OperatorException {
        if (!this.started) {
            return;
        }
        ConfigurationService configurationService = ConfigurationServiceProvider.instance();
        log.info("Operator SDK {} is shutting down...", (Object)configurationService.getVersion().getSdkVersion());
        this.controllerManager.stop();
        ExecutorServiceManager.stop(gracefulShutdownTimeout);
        this.leaderElectionManager.stop();
        if (configurationService.closeClientOnStop()) {
            this.kubernetesClient.close();
        }
        this.started = false;
    }

    @Override
    public void stop() throws OperatorException {
        this.stop(Duration.ZERO);
    }

    public <P extends HasMetadata> RegisteredController<P> register(Reconciler<P> reconciler) throws OperatorException {
        ControllerConfiguration<P> controllerConfiguration = ConfigurationServiceProvider.instance().getConfigurationFor(reconciler);
        return this.register(reconciler, controllerConfiguration);
    }

    public <P extends HasMetadata> RegisteredController<P> register(Reconciler<P> reconciler, ControllerConfiguration<P> configuration) throws OperatorException {
        if (this.started) {
            throw new OperatorException("Operator already started. Register all the controllers before.");
        }
        if (configuration == null) {
            throw new OperatorException("Cannot register reconciler with name " + reconciler.getClass().getCanonicalName() + " reconciler named " + ReconcilerUtils.getNameFor(reconciler) + " because its configuration cannot be found.\n Known reconcilers are: " + ConfigurationServiceProvider.instance().getKnownReconcilerNames());
        }
        Controller<P> controller = new Controller<P>(reconciler, configuration, this.kubernetesClient);
        this.controllerManager.add(controller);
        Object watchedNS = configuration.watchAllNamespaces() ? "[all namespaces]" : configuration.getEffectiveNamespaces();
        log.info("Registered reconciler: '{}' for resource: '{}' for namespace(s): {}", new Object[]{configuration.getName(), configuration.getResourceClass(), watchedNS});
        return controller;
    }

    public <P extends HasMetadata> RegisteredController<P> register(Reconciler<P> reconciler, Consumer<ControllerConfigurationOverrider<P>> configOverrider) {
        ControllerConfiguration<P> controllerConfiguration = ConfigurationServiceProvider.instance().getConfigurationFor(reconciler);
        ControllerConfigurationOverrider<P> configToOverride = ControllerConfigurationOverrider.override(controllerConfiguration);
        configOverrider.accept(configToOverride);
        return this.register(reconciler, configToOverride.build());
    }

    public Optional<RegisteredController> getRegisteredController(String name) {
        return this.controllerManager.get(name).map(RegisteredController.class::cast);
    }

    public Set<RegisteredController> getRegisteredControllers() {
        return new HashSet<RegisteredController>(this.controllerManager.controllers());
    }

    public int getRegisteredControllersNumber() {
        return this.controllerManager.size();
    }

    public RuntimeInfo getRuntimeInfo() {
        return new RuntimeInfo(this);
    }

    boolean isStarted() {
        return this.started;
    }
}

