/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.RegisteredController;
import io.javaoperatorsdk.operator.health.EventSourceHealthIndicator;
import io.javaoperatorsdk.operator.health.InformerWrappingEventSourceHealthIndicator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInfo {
    private static final Logger log = LoggerFactory.getLogger(RuntimeInfo.class);
    private final Set<RegisteredController> registeredControllers;
    private final Operator operator;

    public RuntimeInfo(Operator operator) {
        this.registeredControllers = operator.getRegisteredControllers();
        this.operator = operator;
    }

    public boolean isStarted() {
        return this.operator.isStarted();
    }

    public Set<RegisteredController> getRegisteredControllers() {
        this.checkIfStarted();
        return this.registeredControllers;
    }

    private void checkIfStarted() {
        if (!this.isStarted()) {
            log.warn("Operator not started yet while accessing runtime info, this might lead to an unreliable behavior");
        }
    }

    public boolean allEventSourcesAreHealthy() {
        this.checkIfStarted();
        return this.registeredControllers.stream().filter(rc -> !rc.getControllerHealthInfo().unhealthyEventSources().isEmpty()).findFirst().isEmpty();
    }

    public Map<String, Map<String, EventSourceHealthIndicator>> unhealthyEventSources() {
        this.checkIfStarted();
        HashMap<String, Map<String, EventSourceHealthIndicator>> res = new HashMap<String, Map<String, EventSourceHealthIndicator>>();
        for (RegisteredController rc : this.registeredControllers) {
            res.put(rc.getConfiguration().getName(), rc.getControllerHealthInfo().unhealthyEventSources());
        }
        return res;
    }

    public Map<String, Map<String, InformerWrappingEventSourceHealthIndicator>> unhealthyInformerWrappingEventSourceHealthIndicator() {
        this.checkIfStarted();
        HashMap<String, Map<String, InformerWrappingEventSourceHealthIndicator>> res = new HashMap<String, Map<String, InformerWrappingEventSourceHealthIndicator>>();
        for (RegisteredController rc : this.registeredControllers) {
            res.put(rc.getConfiguration().getName(), rc.getControllerHealthInfo().unhealthyInformerEventSourceHealthIndicators());
        }
        return res;
    }
}

