/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.DefaultResourceClassResolver;
import io.javaoperatorsdk.operator.api.config.InformerStoppedHandler;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.config.ResourceClassResolver;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResourceFactory;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflowFactory;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConfigurationService {
    public static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    public static final int DEFAULT_RECONCILIATION_THREADS_NUMBER = 200;
    public static final int MIN_DEFAULT_RECONCILIATION_THREADS_NUMBER = 10;
    public static final int DEFAULT_WORKFLOW_EXECUTOR_THREAD_NUMBER = 200;
    public static final int MIN_DEFAULT_WORKFLOW_EXECUTOR_THREAD_NUMBER = 10;
    public static final int DEFAULT_TERMINATION_TIMEOUT_SECONDS = 10;

    public <R extends HasMetadata> ControllerConfiguration<R> getConfigurationFor(Reconciler<R> var1);

    default public Config getClientConfiguration() {
        return Config.autoConfigure(null);
    }

    public Set<String> getKnownReconcilerNames();

    public Version getVersion();

    default public boolean checkCRDAndValidateLocalModel() {
        return false;
    }

    default public int concurrentReconciliationThreads() {
        return 200;
    }

    default public int minConcurrentReconciliationThreads() {
        return 10;
    }

    default public int concurrentWorkflowExecutorThreads() {
        return 200;
    }

    default public int minConcurrentWorkflowExecutorThreads() {
        return 10;
    }

    default public Cloner getResourceCloner() {
        return new Cloner(){

            public HasMetadata clone(HasMetadata object) {
                try {
                    ObjectMapper mapper = ConfigurationService.this.getObjectMapper();
                    return (HasMetadata)mapper.readValue(mapper.writeValueAsString((Object)object), object.getClass());
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    @Deprecated(forRemoval=true)
    default public int getTerminationTimeoutSeconds() {
        return 10;
    }

    default public Metrics getMetrics() {
        return Metrics.NOOP;
    }

    default public ExecutorService getExecutorService() {
        return new ThreadPoolExecutor(this.minConcurrentReconciliationThreads(), this.concurrentReconciliationThreads(), 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
    }

    default public ExecutorService getWorkflowExecutorService() {
        return new ThreadPoolExecutor(this.minConcurrentWorkflowExecutorThreads(), this.concurrentWorkflowExecutorThreads(), 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
    }

    default public boolean closeClientOnStop() {
        return true;
    }

    default public ObjectMapper getObjectMapper() {
        return Serialization.jsonMapper();
    }

    default public DependentResourceFactory dependentResourceFactory() {
        return DependentResourceFactory.DEFAULT;
    }

    default public Optional<LeaderElectionConfiguration> getLeaderElectionConfiguration() {
        return Optional.empty();
    }

    default public boolean stopOnInformerErrorDuringStartup() {
        return true;
    }

    default public Duration cacheSyncTimeout() {
        return Duration.ofMinutes(2L);
    }

    default public Optional<InformerStoppedHandler> getInformerStoppedHandler() {
        return Optional.of((informer, ex) -> {
            if (ex != null && informer.hasSynced()) {
                log.error("Fatal error in informer: {}. Stopping the operator", (Object)informer, (Object)ex);
                System.exit(1);
            } else {
                log.debug("Informer stopped: {}. Has synced: {}, Error: {}. This can happen as a result of stopping the controller, or due to an error on startup.See also stopOnInformerErrorDuringStartup configuration.", new Object[]{informer, informer.hasSynced(), ex});
            }
        });
    }

    default public ManagedWorkflowFactory getWorkflowFactory() {
        return ManagedWorkflowFactory.DEFAULT;
    }

    default public ResourceClassResolver getResourceClassResolver() {
        return new DefaultResourceClassResolver();
    }
}

