/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.monitoring;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.Collections;
import java.util.Map;

public interface Metrics {
    public static final Metrics NOOP = new Metrics(){};

    default public void controllerRegistered(Controller<? extends HasMetadata> controller) {
    }

    default public void receivedEvent(Event event, Map<String, Object> metadata) {
    }

    @Deprecated(forRemoval=true)
    default public void reconcileCustomResource(ResourceID resourceID, RetryInfo retryInfo, Map<String, Object> metadata) {
    }

    default public void reconcileCustomResource(HasMetadata resource, RetryInfo retryInfo, Map<String, Object> metadata) {
        this.reconcileCustomResource(ResourceID.fromResource(resource), retryInfo, metadata);
    }

    @Deprecated(forRemoval=true)
    default public void failedReconciliation(ResourceID resourceID, Exception exception, Map<String, Object> metadata) {
    }

    default public void failedReconciliation(HasMetadata resource, Exception exception, Map<String, Object> metadata) {
        this.failedReconciliation(ResourceID.fromResource(resource), exception, metadata);
    }

    default public void reconciliationExecutionStarted(HasMetadata resource, Map<String, Object> metadata) {
    }

    default public void reconciliationExecutionFinished(HasMetadata resource, Map<String, Object> metadata) {
    }

    @Deprecated
    default public void cleanupDoneFor(ResourceID resourceID) {
        this.cleanupDoneFor(resourceID, Collections.emptyMap());
    }

    default public void cleanupDoneFor(ResourceID resourceID, Map<String, Object> metadata) {
    }

    @Deprecated
    default public void finishedReconciliation(ResourceID resourceID) {
        this.finishedReconciliation(resourceID, Collections.emptyMap());
    }

    @Deprecated(forRemoval=true)
    default public void finishedReconciliation(ResourceID resourceID, Map<String, Object> metadata) {
    }

    default public void finishedReconciliation(HasMetadata resource, Map<String, Object> metadata) {
        this.finishedReconciliation(ResourceID.fromResource(resource), metadata);
    }

    default public <T> T timeControllerExecution(ControllerExecution<T> execution) throws Exception {
        return execution.execute();
    }

    default public <T extends Map<?, ?>> T monitorSizeOf(T map, String name) {
        return map;
    }

    public static interface ControllerExecution<T> {
        public String name();

        public String controllerName();

        public String successTypeName(T var1);

        public ResourceID resourceID();

        public Map<String, Object> metadata();

        public T execute() throws Exception;
    }
}

