/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.reconciler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.DefaultManagedDependentResourceContext;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.ManagedDependentResourceContext;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.event.EventSourceRetriever;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultContext<P extends HasMetadata>
implements Context<P> {
    private RetryInfo retryInfo;
    private final Controller<P> controller;
    private final P primaryResource;
    private final ControllerConfiguration<P> controllerConfiguration;
    private final DefaultManagedDependentResourceContext defaultManagedDependentResourceContext;

    public DefaultContext(RetryInfo retryInfo, Controller<P> controller, P primaryResource) {
        this.retryInfo = retryInfo;
        this.controller = controller;
        this.primaryResource = primaryResource;
        this.controllerConfiguration = controller.getConfiguration();
        this.defaultManagedDependentResourceContext = new DefaultManagedDependentResourceContext();
    }

    @Override
    public Optional<RetryInfo> getRetryInfo() {
        return Optional.ofNullable(this.retryInfo);
    }

    @Override
    public <T> Set<T> getSecondaryResources(Class<T> expectedType) {
        return this.controller.getEventSourceManager().getResourceEventSourcesFor(expectedType).stream().map(es -> es.getSecondaryResources(this.primaryResource)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public <T> Optional<T> getSecondaryResource(Class<T> expectedType, String eventSourceName) {
        return this.controller.getEventSourceManager().getResourceEventSourceFor(expectedType, eventSourceName).getSecondaryResource(this.primaryResource);
    }

    @Override
    public <R> Optional<R> getSecondaryResource(Class<R> expectedType, ResourceDiscriminator<R, P> discriminator) {
        return discriminator.distinguish(expectedType, this.primaryResource, this);
    }

    @Override
    public ControllerConfiguration<P> getControllerConfiguration() {
        return this.controllerConfiguration;
    }

    @Override
    public ManagedDependentResourceContext managedDependentResourceContext() {
        return this.defaultManagedDependentResourceContext;
    }

    @Override
    public EventSourceRetriever<P> eventSourceRetriever() {
        return this.controller.getEventSourceManager();
    }

    @Override
    public KubernetesClient getClient() {
        return this.controller.getClient();
    }

    public DefaultContext<P> setRetryInfo(RetryInfo retryInfo) {
        this.retryInfo = retryInfo;
        return this;
    }
}

