/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.reconciler.dependent;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReconcileResult<R> {
    private final Map<R, Operation> resourceOperations;

    public static <T> ReconcileResult<T> resourceCreated(T resource) {
        return new ReconcileResult<T>(resource, Operation.CREATED);
    }

    public static <T> ReconcileResult<T> resourceUpdated(T resource) {
        return new ReconcileResult<T>(resource, Operation.UPDATED);
    }

    public static <T> ReconcileResult<T> noOperation(T resource) {
        return new ReconcileResult<T>(resource, Operation.NONE);
    }

    public static <T> ReconcileResult<T> aggregatedResult(List<ReconcileResult<T>> results) {
        if (results == null) {
            throw new IllegalArgumentException("Should provide results to aggregate");
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        HashMap operations = new HashMap(results.size());
        for (ReconcileResult res : results) {
            res.getSingleResource().ifPresent(r -> operations.put(r, res.getSingleOperation()));
        }
        return new ReconcileResult(operations);
    }

    public String toString() {
        return this.resourceOperations.entrySet().stream().collect(Collectors.toMap(e -> e instanceof HasMetadata ? ResourceID.fromResource((HasMetadata)e) : e, Map.Entry::getValue)).toString();
    }

    private ReconcileResult(R resource, Operation operation) {
        this.resourceOperations = resource != null ? Map.of(resource, operation) : Collections.emptyMap();
    }

    private ReconcileResult(Map<R, Operation> operations) {
        this.resourceOperations = Collections.unmodifiableMap(operations);
    }

    public Optional<R> getSingleResource() {
        return this.resourceOperations.entrySet().stream().findFirst().map(Map.Entry::getKey);
    }

    public Operation getSingleOperation() {
        return this.resourceOperations.entrySet().stream().findFirst().map(Map.Entry::getValue).orElseThrow();
    }

    public Map<R, Operation> getResourceOperations() {
        return this.resourceOperations;
    }

    public static enum Operation {
        CREATED,
        UPDATED,
        NONE;

    }
}

