/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.ResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.GenericResourceUpdatePreProcessor;
import java.util.Objects;

public class GenericKubernetesResourceMatcher<R extends HasMetadata, P extends HasMetadata>
implements Matcher<R, P> {
    private final KubernetesDependentResource<R, P> dependentResource;

    private GenericKubernetesResourceMatcher(KubernetesDependentResource<R, P> dependentResource) {
        this.dependentResource = dependentResource;
    }

    static <R extends HasMetadata, P extends HasMetadata> Matcher<R, P> matcherFor(KubernetesDependentResource<R, P> dependentResource) {
        return new GenericKubernetesResourceMatcher<R, P>(dependentResource);
    }

    @Override
    public Matcher.Result<R> match(R actualResource, P primary, Context<P> context) {
        R desired = this.dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, false, false);
    }

    public static <R extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerMetadata) {
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerMetadata, false);
    }

    public static <R extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerMetadata, boolean equality) {
        if (considerMetadata) {
            boolean matched;
            ObjectMeta desiredMetadata = desired.getMetadata();
            ObjectMeta actualMetadata = actualResource.getMetadata();
            boolean bl = matched = Objects.equals(desiredMetadata.getAnnotations(), actualMetadata.getAnnotations()) && Objects.equals(desiredMetadata.getLabels(), actualMetadata.getLabels());
            if (!matched) {
                return Matcher.Result.computed(false, desired);
            }
        }
        ResourceUpdatePreProcessor<?> processor = GenericResourceUpdatePreProcessor.processorFor(desired.getClass());
        boolean matched = processor.matches(actualResource, desired, equality);
        return Matcher.Result.computed(matched, desired);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerMetadata, boolean strongEquality) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerMetadata, strongEquality);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerMetadata) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerMetadata, false);
    }
}

