/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.ResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.ClusterRoleBindingResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.ClusterRoleResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.ConfigMapResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.RoleBindingResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.RoleResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.SecretResourceUpdatePreProcessor;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.processors.ServiceAccountResourceUpdateProcessor;
import java.util.Map;

public class GenericResourceUpdatePreProcessor<R extends HasMetadata>
implements ResourceUpdatePreProcessor<R> {
    private static final ResourceUpdatePreProcessor<?> INSTANCE = new GenericResourceUpdatePreProcessor();
    private static final Map<Class, ResourceUpdatePreProcessor> processors = Map.of(Secret.class, new SecretResourceUpdatePreProcessor(), ConfigMap.class, new ConfigMapResourceUpdatePreProcessor(), ServiceAccount.class, new ServiceAccountResourceUpdateProcessor(), Role.class, new RoleResourceUpdatePreProcessor(), ClusterRole.class, new ClusterRoleResourceUpdatePreProcessor(), RoleBinding.class, new RoleBindingResourceUpdatePreProcessor(), ClusterRoleBinding.class, new ClusterRoleBindingResourceUpdatePreProcessor());

    protected GenericResourceUpdatePreProcessor() {
    }

    public static <R extends HasMetadata> ResourceUpdatePreProcessor<R> processorFor(Class<R> resourceType) {
        ResourceUpdatePreProcessor<?> processor = processors.get(resourceType);
        return processor != null ? processor : INSTANCE;
    }

    @Override
    public R replaceSpecOnActual(R actual, R desired, Context<?> context) {
        R clonedActual = ConfigurationServiceProvider.instance().getResourceCloner().clone(actual);
        this.updateClonedActual(clonedActual, desired);
        return clonedActual;
    }

    protected void updateClonedActual(R actual, R desired) {
        Object desiredSpec = ReconcilerUtils.getSpec(desired);
        ReconcilerUtils.setSpec(actual, desiredSpec);
    }
}

