/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.api.reconciler.dependent.GarbageCollected;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DependentResourceNode;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowCleanupExecutor;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowCleanupResult;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowReconcileExecutor;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowReconcileResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultWorkflow<P extends HasMetadata>
implements Workflow<P> {
    private final Map<String, DependentResourceNode> dependentResourceNodes;
    private final Set<DependentResourceNode> topLevelResources;
    private final Set<DependentResourceNode> bottomLevelResource;
    private final boolean throwExceptionAutomatically;
    private final boolean hasCleaner;

    DefaultWorkflow(Set<DependentResourceNode> dependentResourceNodes) {
        this(dependentResourceNodes, true, false);
    }

    DefaultWorkflow(Set<DependentResourceNode> dependentResourceNodes, boolean throwExceptionAutomatically, boolean hasCleaner) {
        this.throwExceptionAutomatically = throwExceptionAutomatically;
        this.hasCleaner = hasCleaner;
        if (dependentResourceNodes == null) {
            this.topLevelResources = Collections.emptySet();
            this.bottomLevelResource = Collections.emptySet();
            this.dependentResourceNodes = Collections.emptyMap();
        } else {
            this.topLevelResources = new HashSet<DependentResourceNode>(dependentResourceNodes.size());
            this.bottomLevelResource = new HashSet<DependentResourceNode>(dependentResourceNodes);
            this.dependentResourceNodes = this.toMap(dependentResourceNodes);
        }
    }

    protected DefaultWorkflow(Map<String, DependentResourceNode> dependentResourceNodes, Set<DependentResourceNode> bottomLevelResource, Set<DependentResourceNode> topLevelResources, boolean throwExceptionAutomatically, boolean hasCleaner) {
        this.throwExceptionAutomatically = throwExceptionAutomatically;
        this.hasCleaner = hasCleaner;
        this.topLevelResources = topLevelResources;
        this.bottomLevelResource = bottomLevelResource;
        this.dependentResourceNodes = dependentResourceNodes;
    }

    private Map<String, DependentResourceNode> toMap(Set<DependentResourceNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, DependentResourceNode> map = new HashMap<String, DependentResourceNode>(nodes.size());
        for (DependentResourceNode node : nodes) {
            if (node.getDependsOn().isEmpty()) {
                this.topLevelResources.add(node);
            } else {
                for (DependentResourceNode dependsOn : node.getDependsOn()) {
                    this.bottomLevelResource.remove(dependsOn);
                }
            }
            map.put(node.getName(), node);
        }
        return map;
    }

    @Override
    public WorkflowReconcileResult reconcile(P primary, Context<P> context) {
        WorkflowReconcileExecutor<P> workflowReconcileExecutor = new WorkflowReconcileExecutor<P>(this, primary, context);
        WorkflowReconcileResult result = workflowReconcileExecutor.reconcile();
        if (this.throwExceptionAutomatically) {
            result.throwAggregateExceptionIfErrorsPresent();
        }
        return result;
    }

    @Override
    public WorkflowCleanupResult cleanup(P primary, Context<P> context) {
        WorkflowCleanupExecutor<P> workflowCleanupExecutor = new WorkflowCleanupExecutor<P>(this, primary, context);
        WorkflowCleanupResult result = workflowCleanupExecutor.cleanup();
        if (this.throwExceptionAutomatically) {
            result.throwAggregateExceptionIfErrorsPresent();
        }
        return result;
    }

    @Override
    public Set<DependentResourceNode> getTopLevelDependentResources() {
        return this.topLevelResources;
    }

    @Override
    public Set<DependentResourceNode> getBottomLevelResource() {
        return this.bottomLevelResource;
    }

    @Override
    public boolean hasCleaner() {
        return this.hasCleaner;
    }

    static boolean isDeletable(Class<? extends DependentResource> drClass) {
        boolean isDeleter = Deleter.class.isAssignableFrom(drClass);
        if (!isDeleter) {
            return false;
        }
        if (KubernetesDependentResource.class.isAssignableFrom(drClass)) {
            return !GarbageCollected.class.isAssignableFrom(drClass);
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.dependentResourceNodes.isEmpty();
    }

    @Override
    public Map<String, DependentResource> getDependentResourcesByName() {
        HashMap<String, DependentResource> resources = new HashMap<String, DependentResource>(this.dependentResourceNodes.size());
        this.dependentResourceNodes.forEach((name, node) -> resources.put((String)name, node.getDependentResource()));
        return resources;
    }
}

