/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DefaultWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflowSupport;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import java.util.List;

public interface ManagedWorkflowFactory<C extends ControllerConfiguration<?>> {
    public static final ManagedWorkflowFactory DEFAULT = configuration -> {
        List<DependentResourceSpec> dependentResourceSpecs = configuration.getDependentResources();
        if (dependentResourceSpecs == null || dependentResourceSpecs.isEmpty()) {
            return new ManagedWorkflow(){

                @Override
                public boolean hasCleaner() {
                    return false;
                }

                @Override
                public boolean isEmpty() {
                    return true;
                }

                public Workflow resolve(KubernetesClient client, ControllerConfiguration configuration) {
                    return new DefaultWorkflow(null);
                }
            };
        }
        return ManagedWorkflowSupport.instance().createWorkflow(dependentResourceSpecs);
    };

    public ManagedWorkflow workflowFor(C var1);
}

