/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DefaultWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DependentResourceNode;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WorkflowBuilder<P extends HasMetadata> {
    private final Map<String, DependentResourceNode<?, P>> dependentResourceNodes = new HashMap();
    private boolean throwExceptionAutomatically = true;
    private DependentResourceNode currentNode;
    private boolean isCleaner = false;

    public WorkflowBuilder<P> addDependentResource(DependentResource dependentResource) {
        this.currentNode = new DependentResourceNode(dependentResource);
        this.isCleaner = this.isCleaner || dependentResource.isDeletable();
        String name = this.currentNode.getName();
        this.dependentResourceNodes.put(name, this.currentNode);
        return this;
    }

    public WorkflowBuilder<P> dependsOn(Set<DependentResource> dependentResources) {
        for (DependentResource dependentResource : dependentResources) {
            DependentResourceNode dependsOn = this.getNodeByDependentResource(dependentResource);
            this.currentNode.addDependsOnRelation(dependsOn);
        }
        return this;
    }

    public WorkflowBuilder<P> dependsOn(DependentResource ... dependentResources) {
        if (dependentResources != null) {
            return this.dependsOn(new HashSet<DependentResource>(Arrays.asList(dependentResources)));
        }
        return this;
    }

    public WorkflowBuilder<P> withReconcilePrecondition(Condition reconcilePrecondition) {
        this.currentNode.setReconcilePrecondition(reconcilePrecondition);
        return this;
    }

    public WorkflowBuilder<P> withReadyPostcondition(Condition readyPostcondition) {
        this.currentNode.setReadyPostcondition(readyPostcondition);
        return this;
    }

    public WorkflowBuilder<P> withDeletePostcondition(Condition deletePostcondition) {
        this.currentNode.setDeletePostcondition(deletePostcondition);
        return this;
    }

    DependentResourceNode getNodeByDependentResource(DependentResource<?, ?> dependentResource) {
        DependentResourceNode<?, P> node = this.dependentResourceNodes.get(DependentResourceNode.getNameFor(dependentResource));
        if (node != null) {
            return node;
        }
        return this.dependentResourceNodes.values().stream().filter(dr -> dr.getDependentResource() == dependentResource).findFirst().orElseThrow();
    }

    public WorkflowBuilder<P> withThrowExceptionFurther(boolean throwExceptionFurther) {
        this.throwExceptionAutomatically = throwExceptionFurther;
        return this;
    }

    public Workflow<P> build() {
        return new DefaultWorkflow(new HashSet<DependentResourceNode>(this.dependentResourceNodes.values()), this.throwExceptionAutomatically, this.isCleaner);
    }
}

