/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.AbstractWorkflowExecutor;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DependentResourceNode;
import io.javaoperatorsdk.operator.processing.dependent.workflow.NodeExecutor;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowCleanupResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCleanupExecutor<P extends HasMetadata>
extends AbstractWorkflowExecutor<P> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowCleanupExecutor.class);
    private final Set<DependentResourceNode> postDeleteConditionNotMet = ConcurrentHashMap.newKeySet();
    private final Set<DependentResourceNode> deleteCalled = ConcurrentHashMap.newKeySet();

    public WorkflowCleanupExecutor(Workflow<P> workflow, P primary, Context<P> context) {
        super(workflow, primary, context);
    }

    public synchronized WorkflowCleanupResult cleanup() {
        for (DependentResourceNode dependentResourceNode : this.workflow.getBottomLevelResource()) {
            this.handleCleanup(dependentResourceNode);
        }
        this.waitForScheduledExecutionsToRun();
        return this.createCleanupResult();
    }

    @Override
    protected Logger logger() {
        return log;
    }

    private synchronized void handleCleanup(DependentResourceNode dependentResourceNode) {
        log.debug("Submitting for cleanup: {}", (Object)dependentResourceNode);
        if (this.alreadyVisited(dependentResourceNode) || this.isExecutingNow(dependentResourceNode) || !this.allDependentsCleaned(dependentResourceNode) || this.hasErroredDependent(dependentResourceNode)) {
            log.debug("Skipping submit of: {}, ", (Object)dependentResourceNode);
            return;
        }
        Future<?> nodeFuture = ExecutorServiceManager.instance().workflowExecutorService().submit(new CleanupExecutor(dependentResourceNode));
        this.markAsExecuting(dependentResourceNode, nodeFuture);
        log.debug("Submitted for cleanup: {}", (Object)dependentResourceNode);
    }

    private synchronized void handleDependentCleaned(DependentResourceNode<?, P> dependentResourceNode) {
        List<DependentResourceNode> dependOns = dependentResourceNode.getDependsOn();
        if (dependOns != null) {
            dependOns.forEach(d -> {
                log.debug("Handle cleanup for dependent: {} of parent:{}", d, (Object)dependentResourceNode);
                this.handleCleanup((DependentResourceNode)d);
            });
        }
    }

    private boolean allDependentsCleaned(DependentResourceNode dependentResourceNode) {
        List<DependentResourceNode> parents = dependentResourceNode.getParents();
        return parents.isEmpty() || parents.stream().allMatch(d -> this.alreadyVisited(d) && !this.postDeleteConditionNotMet.contains(d));
    }

    private boolean hasErroredDependent(DependentResourceNode dependentResourceNode) {
        List<DependentResourceNode> parents = dependentResourceNode.getParents();
        return !parents.isEmpty() && parents.stream().anyMatch(this::isInError);
    }

    private WorkflowCleanupResult createCleanupResult() {
        Map<DependentResource, Exception> erroredDependents = this.getErroredDependents();
        List<DependentResource> postConditionNotMet = this.postDeleteConditionNotMet.stream().map(DependentResourceNode::getDependentResource).collect(Collectors.toList());
        List<DependentResource> deleteCalled = this.deleteCalled.stream().map(DependentResourceNode::getDependentResource).collect(Collectors.toList());
        return new WorkflowCleanupResult(erroredDependents, postConditionNotMet, deleteCalled);
    }

    private class CleanupExecutor<R>
    extends NodeExecutor<R, P> {
        private CleanupExecutor(DependentResourceNode<R, P> drn) {
            super(drn, WorkflowCleanupExecutor.this);
        }

        @Override
        protected void doRun(DependentResourceNode<R, P> dependentResourceNode, DependentResource<R, P> dependentResource) {
            boolean deletePostConditionMet;
            Optional deletePostCondition = dependentResourceNode.getDeletePostcondition();
            if (dependentResource.isDeletable()) {
                ((Deleter)((Object)dependentResource)).delete(WorkflowCleanupExecutor.this.primary, WorkflowCleanupExecutor.this.context);
                WorkflowCleanupExecutor.this.deleteCalled.add(dependentResourceNode);
            }
            if (deletePostConditionMet = WorkflowCleanupExecutor.this.isConditionMet(deletePostCondition, dependentResource)) {
                WorkflowCleanupExecutor.this.markAsVisited(dependentResourceNode);
                WorkflowCleanupExecutor.this.handleDependentCleaned(dependentResourceNode);
            } else {
                WorkflowCleanupExecutor.this.postDeleteConditionNotMet.add(dependentResourceNode);
                WorkflowCleanupExecutor.this.markAsVisited(dependentResourceNode);
            }
        }
    }
}

