/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.processing.event.ResourceID;

class ExecutionScope<R extends HasMetadata> {
    private R resource;
    private final RetryInfo retryInfo;

    ExecutionScope(RetryInfo retryInfo) {
        this.retryInfo = retryInfo;
    }

    public ExecutionScope<R> setResource(R resource) {
        this.resource = resource;
        return this;
    }

    public R getResource() {
        return this.resource;
    }

    public ResourceID getResourceID() {
        return ResourceID.fromResource(this.resource);
    }

    public String toString() {
        if (this.resource == null) {
            return "ExecutionScope{resource: null}";
        }
        return "ExecutionScope{ resource id: " + ResourceID.fromResource(this.resource) + ", version: " + this.resource.getMetadata().getResourceVersion() + "}";
    }

    public RetryInfo getRetryInfo() {
        return this.retryInfo;
    }
}

