/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ResourceID
implements Serializable {
    private final String name;
    private final String namespace;

    public static ResourceID fromResource(HasMetadata resource) {
        return new ResourceID(resource.getMetadata().getName(), resource.getMetadata().getNamespace());
    }

    public static Optional<ResourceID> fromFirstOwnerReference(HasMetadata resource) {
        return ResourceID.fromFirstOwnerReference(resource, false);
    }

    public static Optional<ResourceID> fromFirstOwnerReference(HasMetadata resource, boolean clusterScoped) {
        List ownerReferences = resource.getMetadata().getOwnerReferences();
        if (!ownerReferences.isEmpty()) {
            return Optional.of(new ResourceID(((OwnerReference)ownerReferences.get(0)).getName(), clusterScoped ? null : resource.getMetadata().getNamespace()));
        }
        return Optional.empty();
    }

    public ResourceID(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public ResourceID(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceID that = (ResourceID)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace);
    }

    public boolean isSameResource(HasMetadata hasMetadata) {
        ObjectMeta metadata = hasMetadata.getMetadata();
        return this.getName().equals(metadata.getName()) && this.getNamespace().map(ns -> ns.equals(metadata.getNamespace())).orElse(true) != false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace);
    }

    public String toString() {
        return ResourceID.toString(this.name, this.namespace);
    }

    public static String toString(HasMetadata resource) {
        return ResourceID.toString(resource.getMetadata().getName(), resource.getMetadata().getNamespace());
    }

    private static String toString(String name, String namespace) {
        return "ResourceID{name='" + name + "', namespace='" + namespace + "'}";
    }
}

