/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.processing.event.source.cache.BoundedCache;
import io.javaoperatorsdk.operator.processing.event.source.cache.KubernetesResourceFetcher;
import io.javaoperatorsdk.operator.processing.event.source.cache.ResourceFetcher;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedItemStore<R extends HasMetadata>
implements ItemStore<R> {
    private static final Logger log = LoggerFactory.getLogger(BoundedItemStore.class);
    private final ResourceFetcher<String, R> resourceFetcher;
    private final BoundedCache<String, R> cache;
    private final Function<R, String> keyFunction;
    private final Map<String, R> existingMinimalResources = new ConcurrentHashMap<String, R>();
    private final Constructor<R> resourceConstructor;

    public BoundedItemStore(BoundedCache<String, R> cache, Class<R> resourceClass, KubernetesClient client) {
        this(cache, resourceClass, BoundedItemStore.namespaceKeyFunc(), new KubernetesResourceFetcher<R>(resourceClass, client));
    }

    public BoundedItemStore(BoundedCache<String, R> cache, Class<R> resourceClass, Function<R, String> keyFunction, ResourceFetcher<String, R> resourceFetcher) {
        this.resourceFetcher = resourceFetcher;
        this.cache = cache;
        this.keyFunction = keyFunction;
        this.resourceConstructor = Utils.getConstructor(resourceClass);
    }

    public String getKey(R obj) {
        return this.keyFunction.apply(obj);
    }

    public synchronized R put(String key, R obj) {
        HasMetadata result = (HasMetadata)this.existingMinimalResources.get(key);
        this.cache.put(key, obj);
        this.existingMinimalResources.put(key, this.createMinimalResource(obj));
        return (R)result;
    }

    private R createMinimalResource(R obj) {
        try {
            HasMetadata minimal = (HasMetadata)this.resourceConstructor.newInstance(new Object[0]);
            ObjectMeta metadata = obj.getMetadata();
            minimal.setMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(metadata.getName())).withNamespace(metadata.getNamespace())).withResourceVersion(metadata.getResourceVersion())).build());
            return (R)minimal;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized R remove(String key) {
        HasMetadata fullValue = (HasMetadata)this.cache.remove(key);
        HasMetadata minimalValue = (HasMetadata)this.existingMinimalResources.remove(key);
        return (R)(fullValue != null ? fullValue : minimalValue);
    }

    public Stream<String> keySet() {
        return this.existingMinimalResources.keySet().stream();
    }

    public Stream<R> values() {
        return this.existingMinimalResources.values().stream();
    }

    public int size() {
        return this.existingMinimalResources.size();
    }

    public R get(String key) {
        HasMetadata res = (HasMetadata)this.cache.get(key);
        if (res != null) {
            return (R)res;
        }
        if (!this.existingMinimalResources.containsKey(key)) {
            return null;
        }
        return this.refreshMissingStateFromServer(key);
    }

    public boolean isFullState() {
        return false;
    }

    public static <R extends HasMetadata> Function<R, String> namespaceKeyFunc() {
        return r -> Cache.namespaceKeyFunc((String)r.getMetadata().getNamespace(), (String)r.getMetadata().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected R refreshMissingStateFromServer(String key) {
        log.debug("Fetching resource from server for key: {}", (Object)key);
        HasMetadata newRes = (HasMetadata)this.resourceFetcher.fetchResource(key);
        BoundedItemStore boundedItemStore = this;
        synchronized (boundedItemStore) {
            log.debug("Fetched resource: {}", (Object)newRes);
            HasMetadata actual = (HasMetadata)this.cache.get(key);
            if (newRes == null) {
                if (actual == null) {
                    this.existingMinimalResources.remove(key);
                    return null;
                }
                return (R)actual;
            }
            if (actual == null) {
                this.cache.put(key, newRes);
                this.existingMinimalResources.put(key, this.createMinimalResource(newRes));
                return (R)newRes;
            }
            return (R)actual;
        }
    }
}

