/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.cache.ResourceFetcher;
import java.util.function.Function;

public class KubernetesResourceFetcher<R extends HasMetadata>
implements ResourceFetcher<String, R> {
    private final Class<R> rClass;
    private final KubernetesClient client;
    private final Function<String, ResourceID> resourceIDFunction;

    public KubernetesResourceFetcher(Class<R> rClass, KubernetesClient client) {
        this(rClass, client, KubernetesResourceFetcher.inverseNamespaceKeyFunction());
    }

    public KubernetesResourceFetcher(Class<R> rClass, KubernetesClient client, Function<String, ResourceID> resourceIDFunction) {
        this.rClass = rClass;
        this.client = client;
        this.resourceIDFunction = resourceIDFunction;
    }

    @Override
    public R fetchResource(String key) {
        ResourceID resourceId = this.resourceIDFunction.apply(key);
        return (R)resourceId.getNamespace().map(ns -> (HasMetadata)((Resource)((NonNamespaceOperation)this.client.resources(this.rClass).inNamespace(ns)).withName(resourceId.getName())).get()).orElse((HasMetadata)((Resource)this.client.resources(this.rClass).withName(resourceId.getName())).get());
    }

    public static Function<String, ResourceID> inverseNamespaceKeyFunction() {
        return s -> {
            int delimiterIndex = s.indexOf("/");
            if (delimiterIndex == -1) {
                return new ResourceID((String)s);
            }
            return new ResourceID(s.substring(delimiterIndex + 1), s.substring(0, delimiterIndex));
        };
    }
}

