/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventRecorder<R extends HasMetadata> {
    private final Map<ResourceID, ArrayList<R>> resourceEvents = new HashMap<ResourceID, ArrayList<R>>();

    public void startEventRecording(ResourceID resourceID) {
        this.resourceEvents.putIfAbsent(resourceID, new ArrayList(5));
    }

    public boolean isRecordingFor(ResourceID resourceID) {
        return this.resourceEvents.get(resourceID) != null;
    }

    public void stopEventRecording(ResourceID resourceID) {
        this.resourceEvents.remove(resourceID);
    }

    public void recordEvent(R resource) {
        this.resourceEvents.get(ResourceID.fromResource(resource)).add(resource);
    }

    public boolean containsEventWithResourceVersion(ResourceID resourceID, String resourceVersion) {
        List events = this.resourceEvents.get(resourceID);
        if (events == null) {
            return false;
        }
        if (events.isEmpty()) {
            return false;
        }
        return events.stream().anyMatch(e -> e.getMetadata().getResourceVersion().equals(resourceVersion));
    }

    public boolean containsEventWithVersionButItsNotLastOne(ResourceID resourceID, String resourceVersion) {
        List resources = this.resourceEvents.get(resourceID);
        if (resources == null) {
            throw new IllegalStateException("Null events list, this is probably a result of invalid usage of the InformerEventSource. Resource ID: " + resourceID);
        }
        if (resources.isEmpty()) {
            throw new IllegalStateException("No events for resource id: " + resourceID);
        }
        return !((HasMetadata)resources.get(resources.size() - 1)).getMetadata().getResourceVersion().equals(resourceVersion);
    }

    public R getLastEvent(ResourceID resourceID) {
        List resources = this.resourceEvents.get(resourceID);
        if (resources == null) {
            throw new IllegalStateException("Null events list, this is probably a result of invalid usage of the InformerEventSource. Resource ID: " + resourceID);
        }
        return (R)((HasMetadata)resources.get(resources.size() - 1));
    }
}

