/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.dependent.RecentOperationEventFilter;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.EventHandler;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.PrimaryToSecondaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.informer.DefaultPrimaryToSecondaryIndex;
import io.javaoperatorsdk.operator.processing.event.source.informer.EventRecorder;
import io.javaoperatorsdk.operator.processing.event.source.informer.ManagedInformerEventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.NOOPPrimaryToSecondaryIndex;
import io.javaoperatorsdk.operator.processing.event.source.informer.PrimaryToSecondaryIndex;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformerEventSource<R extends HasMetadata, P extends HasMetadata>
extends ManagedInformerEventSource<R, P, InformerConfiguration<R>>
implements ResourceEventHandler<R>,
RecentOperationEventFilter<R> {
    private static final Logger log = LoggerFactory.getLogger(InformerEventSource.class);
    private final InformerConfiguration<R> configuration;
    private final EventRecorder<R> eventRecorder = new EventRecorder();
    private final PrimaryToSecondaryIndex<R> primaryToSecondaryIndex;
    private final PrimaryToSecondaryMapper<P> primaryToSecondaryMapper;

    public InformerEventSource(InformerConfiguration<R> configuration, EventSourceContext<P> context) {
        this(configuration, context.getClient());
    }

    public InformerEventSource(InformerConfiguration<R> configuration, KubernetesClient client) {
        super(client.resources(configuration.getResourceClass()), configuration);
        this.configuration = configuration;
        this.primaryToSecondaryMapper = configuration.getPrimaryToSecondaryMapper();
        this.primaryToSecondaryIndex = this.primaryToSecondaryMapper == null ? new DefaultPrimaryToSecondaryIndex<R>(configuration.getSecondaryToPrimaryMapper()) : NOOPPrimaryToSecondaryIndex.getInstance();
        this.onAddFilter = configuration.onAddFilter().orElse(null);
        this.onUpdateFilter = configuration.onUpdateFilter().orElse(null);
        this.onDeleteFilter = configuration.onDeleteFilter().orElse(null);
        this.genericFilter = configuration.genericFilter().orElse(null);
    }

    @Override
    public void onAdd(R newResource) {
        if (log.isDebugEnabled()) {
            log.debug("On add event received for resource id: {} type: {}", (Object)ResourceID.fromResource(newResource), (Object)this.resourceType().getSimpleName());
        }
        this.primaryToSecondaryIndex.onAddOrUpdate(newResource);
        this.onAddOrUpdate(Operation.ADD, newResource, null, () -> InformerEventSource.super.onAdd(newResource));
    }

    @Override
    public void onUpdate(R oldObject, R newObject) {
        if (log.isDebugEnabled()) {
            log.debug("On update event received for resource id: {} type: {}", (Object)ResourceID.fromResource(newObject), (Object)this.resourceType().getSimpleName());
        }
        this.primaryToSecondaryIndex.onAddOrUpdate(newObject);
        this.onAddOrUpdate(Operation.UPDATE, newObject, oldObject, () -> InformerEventSource.super.onUpdate(oldObject, newObject));
    }

    @Override
    public void onDelete(R resource, boolean b) {
        if (log.isDebugEnabled()) {
            log.debug("On delete event received for resource id: {} type: {}", (Object)ResourceID.fromResource(resource), (Object)this.resourceType().getSimpleName());
        }
        this.primaryToSecondaryIndex.onDelete(resource);
        super.onDelete(resource, b);
        if (this.acceptedByDeleteFilters(resource, b)) {
            this.propagateEvent(resource);
        }
    }

    private synchronized void onAddOrUpdate(Operation operation, R newObject, R oldObject, Runnable superOnOp) {
        ResourceID resourceID = ResourceID.fromResource(newObject);
        if (this.eventRecorder.isRecordingFor(resourceID)) {
            log.debug("Recording event for: {}", (Object)resourceID);
            this.eventRecorder.recordEvent(newObject);
            return;
        }
        if (this.temporaryCacheHasResourceWithSameVersionAs(newObject)) {
            log.debug("Skipping event propagation for {}, since was a result of a reconcile action. Resource ID: {}", (Object)operation, (Object)ResourceID.fromResource(newObject));
            superOnOp.run();
        } else {
            superOnOp.run();
            if (this.eventAcceptedByFilter(operation, newObject, oldObject)) {
                log.debug("Propagating event for {}, resource with same version not result of a reconciliation. Resource ID: {}", (Object)operation, (Object)resourceID);
                this.propagateEvent(newObject);
            } else {
                log.debug("Event filtered out for operation: {}, resourceID: {}", (Object)operation, (Object)resourceID);
            }
        }
    }

    private boolean temporaryCacheHasResourceWithSameVersionAs(R resource) {
        ResourceID resourceID = ResourceID.fromResource(resource);
        Optional<HasMetadata> res = this.temporaryResourceCache.getResourceFromCache(resourceID);
        return res.map(r -> {
            boolean resVersionsEqual = r.getMetadata().getResourceVersion().equals(resource.getMetadata().getResourceVersion());
            log.debug("Resource found in temporal cache for id: {} resource versions equal: {}", (Object)resourceID, (Object)resVersionsEqual);
            return resVersionsEqual;
        }).orElse(false);
    }

    private void propagateEvent(R object) {
        Set<ResourceID> primaryResourceIdSet = this.configuration.getSecondaryToPrimaryMapper().toPrimaryResourceIDs(object);
        if (primaryResourceIdSet.isEmpty()) {
            return;
        }
        primaryResourceIdSet.forEach(resourceId -> {
            Event event = new Event((ResourceID)resourceId);
            EventHandler eventHandler = this.getEventHandler();
            if (eventHandler != null) {
                eventHandler.handleEvent(event);
            }
        });
    }

    @Override
    public Set<R> getSecondaryResources(P primary) {
        Set<ResourceID> secondaryIDs;
        if (this.useSecondaryToPrimaryIndex()) {
            ResourceID primaryResourceID = ResourceID.fromResource(primary);
            secondaryIDs = this.primaryToSecondaryIndex.getSecondaryResources(primaryResourceID);
            log.debug("Using PrimaryToSecondaryIndex to find secondary resources for primary: {}. Found secondary ids: {} ", (Object)primaryResourceID, secondaryIDs);
        } else {
            secondaryIDs = this.primaryToSecondaryMapper.toSecondaryResourceIDs(primary);
            log.debug("Using PrimaryToSecondaryMapper to find secondary resources for primary: {}. Found secondary ids: {} ", primary, secondaryIDs);
        }
        return secondaryIDs.stream().map(this::get).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    public InformerConfiguration<R> getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void handleRecentResourceUpdate(ResourceID resourceID, R resource, R previousVersionOfResource) {
        this.handleRecentCreateOrUpdate(Operation.UPDATE, resource, previousVersionOfResource, () -> super.handleRecentResourceUpdate(resourceID, resource, previousVersionOfResource));
    }

    @Override
    public synchronized void handleRecentResourceCreate(ResourceID resourceID, R resource) {
        this.handleRecentCreateOrUpdate(Operation.ADD, resource, null, () -> super.handleRecentResourceCreate(resourceID, resource));
    }

    private void handleRecentCreateOrUpdate(Operation operation, R resource, R oldResource, Runnable runnable) {
        this.primaryToSecondaryIndex.onAddOrUpdate(resource);
        if (this.eventRecorder.isRecordingFor(ResourceID.fromResource(resource))) {
            this.handleRecentResourceOperationAndStopEventRecording(operation, resource, oldResource);
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecentResourceOperationAndStopEventRecording(Operation operation, R newResource, R oldResource) {
        ResourceID resourceID = ResourceID.fromResource(newResource);
        try {
            if (!this.eventRecorder.containsEventWithResourceVersion(resourceID, newResource.getMetadata().getResourceVersion())) {
                log.debug("Did not found event in buffer with target version and resource id: {}", (Object)resourceID);
                this.temporaryResourceCache.unconditionallyCacheResource(newResource);
            } else if (this.eventRecorder.containsEventWithVersionButItsNotLastOne(resourceID, newResource.getMetadata().getResourceVersion())) {
                R lastEvent = this.eventRecorder.getLastEvent(resourceID);
                log.debug("Found events in event buffer but the target event is not last for id: {}. Propagating event.", (Object)resourceID);
                if (this.eventAcceptedByFilter(operation, newResource, oldResource)) {
                    this.propagateEvent(lastEvent);
                }
            }
        }
        finally {
            this.eventRecorder.stopEventRecording(resourceID);
        }
    }

    private boolean useSecondaryToPrimaryIndex() {
        return this.primaryToSecondaryMapper == null;
    }

    @Override
    public synchronized void prepareForCreateOrUpdateEventFiltering(ResourceID resourceID, R resource) {
        log.debug("Starting event recording for: {}", (Object)resourceID);
        this.eventRecorder.startEventRecording(resourceID);
    }

    @Override
    public synchronized void cleanupOnCreateOrUpdateEventFiltering(ResourceID resourceID) {
        log.debug("Stopping event recording for: {}", (Object)resourceID);
        this.eventRecorder.stopEventRecording(resourceID);
    }

    @Override
    public boolean allowsNamespaceChanges() {
        return this.getConfiguration().followControllerNamespaceChanges();
    }

    private boolean eventAcceptedByFilter(Operation operation, R newObject, R oldObject) {
        if (this.genericFilter != null && !this.genericFilter.accept(newObject)) {
            return false;
        }
        if (operation == Operation.ADD) {
            return this.onAddFilter == null || this.onAddFilter.accept(newObject);
        }
        return this.onUpdateFilter == null || this.onUpdateFilter.accept(newObject, oldObject);
    }

    private boolean acceptedByDeleteFilters(R resource, boolean b) {
        return !(this.onDeleteFilter != null && !this.onDeleteFilter.accept(resource, b) || this.genericFilter != null && !this.genericFilter.accept(resource));
    }

    private static enum Operation {
        ADD,
        UPDATE;

    }
}

