/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.informer.ManagedInformerEventSource;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryResourceCache<T extends HasMetadata> {
    private static final Logger log = LoggerFactory.getLogger(TemporaryResourceCache.class);
    private final Map<ResourceID, T> cache = new ConcurrentHashMap<ResourceID, T>();
    private final ManagedInformerEventSource<T, ?, ?> managedInformerEventSource;

    public TemporaryResourceCache(ManagedInformerEventSource<T, ?, ?> managedInformerEventSource) {
        this.managedInformerEventSource = managedInformerEventSource;
    }

    public synchronized void removeResourceFromCache(T resource) {
        this.cache.remove(ResourceID.fromResource(resource));
    }

    public synchronized void unconditionallyCacheResource(T newResource) {
        this.putToCache(newResource, null);
    }

    public synchronized void putAddedResource(T newResource) {
        ResourceID resourceID = ResourceID.fromResource(newResource);
        if (this.managedInformerEventSource.get(resourceID).isEmpty()) {
            log.debug("Putting resource to cache with ID: {}", (Object)resourceID);
            this.putToCache(newResource, resourceID);
        } else {
            log.debug("Won't put resource into cache found already informer cache: {}", (Object)resourceID);
        }
    }

    public synchronized void putUpdatedResource(T newResource, String previousResourceVersion) {
        ResourceID resourceId = ResourceID.fromResource(newResource);
        Optional<T> informerCacheResource = this.managedInformerEventSource.get(resourceId);
        if (informerCacheResource.isEmpty()) {
            log.debug("No cached value present for resource: {}", newResource);
            return;
        }
        if (((HasMetadata)informerCacheResource.get()).getMetadata().getResourceVersion().equals(previousResourceVersion)) {
            log.debug("Putting resource to temporal cache with id: {}", (Object)resourceId);
            this.putToCache(newResource, resourceId);
        } else {
            log.debug("Trying to remove an obsolete resource from cache for id: {}", (Object)resourceId);
            this.cache.remove(resourceId);
        }
    }

    private void putToCache(T resource, ResourceID resourceID) {
        this.cache.put(resourceID == null ? ResourceID.fromResource(resource) : resourceID, resource);
    }

    public synchronized Optional<T> getResourceFromCache(ResourceID resourceID) {
        return Optional.ofNullable((HasMetadata)this.cache.get(resourceID));
    }
}

