/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.retry;

import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.RetryExecution;
import java.util.Optional;

public class GenericRetryExecution
implements RetryExecution {
    private final GenericRetry genericRetry;
    private int lastAttemptIndex = 0;
    private long currentInterval;

    public GenericRetryExecution(GenericRetry genericRetry) {
        this.genericRetry = genericRetry;
        this.currentInterval = genericRetry.getInitialInterval();
    }

    @Override
    public Optional<Long> nextDelay() {
        if (this.genericRetry.getMaxAttempts() > -1 && this.lastAttemptIndex >= this.genericRetry.getMaxAttempts()) {
            return Optional.empty();
        }
        if (this.lastAttemptIndex > 1) {
            this.currentInterval = (long)((double)this.currentInterval * this.genericRetry.getIntervalMultiplier());
            if (this.genericRetry.getMaxInterval() > -1L && this.currentInterval > this.genericRetry.getMaxInterval()) {
                this.currentInterval = this.genericRetry.getMaxInterval();
            }
        }
        ++this.lastAttemptIndex;
        return Optional.of(this.currentInterval);
    }

    @Override
    public boolean isLastAttempt() {
        return this.genericRetry.getMaxAttempts() > -1 && this.lastAttemptIndex >= this.genericRetry.getMaxAttempts();
    }

    @Override
    public int getAttemptCount() {
        return this.lastAttemptIndex;
    }
}

